/****************************************************************************
  Hyper Operating System V4 Advance
  %jp{荞݃nh(MN1030V[Yp}%en{MN1030}

  Copyright (C) 1998-2007 by Project HOS
  http://sourceforge.jp/projects/hos/
****************************************************************************/


				.global	__kernel_int_hdr
				.global	__kernel_ictxcb
				.global	__kernel_sta_inh
				.global	__kernel_end_inh
				.global	__kernel_exe_inh


				.text
				.align	2


/************************************************
  Interrupt Handler
 ************************************************/
__kernel_int_hdr:
			/* ---- WX^ޔ ---- */
				movm	[other], (sp)							/* WX^ޔ */
				add		-8, sp
				
			/* ---- dݔ ---- */
				mov		__kernel_ictxcb, a0
				movbu	(4, a0), d0
				add		1, d0
				movbu	d0, (4, a0)
				cmp		1, d0
				bne		multiple_int
				
			/* ---- 荞ݗpX^bNɓւ ---- */
				mov		(0, a0), a1
				mov		sp, a0									/* ^XNSPۑ */
				mov		a1, sp
				add		-16, sp
				mov		a0, (12, sp)
				
			/* ---- 荞ݏ ---- */
				call	__kernel_sta_inh, [], 0					/* 荞݊Jn */
				
			/* ---- 荞݃nhs ---- */
				clr		d0
				call	__kernel_exe_inh, [], 0
				
			/* ---- 荞ݏ̏Iݒ ---- */
				mov		(12, sp), a0
				clr		d0
				movbu	d0, (__kernel_ictxcb+4)					/* lXgJE^NA */
				mov		a0, sp									/* X^bNA */
				
			/* ---- ݃}XNx̕A ---- */
				mov		(40, sp), d0
				and		0x0700, d0
				mov		d0, psw
				
			/* ---- xfBXpb` ---- */
				call	__kernel_end_inh, [], 0					/* 荞ݏI */
				
			/* ---- A ---- */
return_int:
				add		8, sp
				movm	(sp), [other]							/* WX^ޔ */
				rti

			/* ---- d荞ݏ ---- */
multiple_int:
			/* ---- 荞݃nhs ---- */
				clr		d0
				call	__kernel_exe_inh, [], 0
				
			/* ---- 荞݃JE^A ---- */
				movbu	(__kernel_ictxcb+4), d0
				add		-1, d0
				movbu	d0, (__kernel_ictxcb+4)
				
				bra		return_int								/* A */


				.end


/* end of file */
