/* ------------------------------------------------------------------------ */
/* Hyper Operating System V4 Advance                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2010 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


				.global	__kernel_int_hdr
				.global	__kernel_ictxcb
				.global	__kernel_sta_inh
				.global	__kernel_exe_inh
				.global	__kernel_end_inh


				.text


#define ICTXCB_IMSK		0
#define ICTXCB_INTCNT	2
#define ICTXCB_ISP		4


/************************************************
  ݃nh

  WX^oNȏ̑d݃lXg͖
 ̂ƂB
 ************************************************/
				.align	2
__kernel_int_hdr:
		/* ---- d݂}XN */
				stc		sr, r0
		/*		mov		r0, r8			*/			/* r8  sr ۑ */
				or		#0xf0, r0
				ldc		r0, sr						/* S݃}XN */
				
		/* ---- ݔԍ擾 */
				mov.l	addr_ibnr, r0
				mov.l	@r0, r0
				and		#0x0f, r0
				shll8	r0
				shlr	r0
				add		#-64, r0
				ldbank	@r0, r0
				shlr2	r0
				mov		r0, r9						/* r9Ɋ荞ݔԍ */
				
		/* ---- ݃}XNl̐ݒ聕dݔ */
				mov.l	addr_ictxcb, r10
				mov.b	@(ICTXCB_INTCNT, r10), r0	/* ݃lXgJE^o */
				cmp/eq	#0, r0						/* 񊄍ݔ */
				mov.w	@r0, r11					/* r11ɌÂ݃}XNli[ */
				add		#1, r0						/* ݃lXgJE^Z */
				mov.w	r0, @(ICTXCB_IMSK, r10)		/* V݃}XNlݒ */
				bf/s	multiple_int				/* dݏ֕ */
				mov.b	r0, @(ICTXCB_INTCNT, r10)	/* ݃lXglݒ(xXbg) */
				
		/* ==== 񊄍݂̏ */
				
		/* ---- X^bNւ */
				mov		r15, r12					/* r12Ɍ݂̃X^bNޔ */
				mov.l	@(ICTXCB_ISP, r10), r15		/* ݗpX^bNݒ */
				
		/* ---- ݊JnĂяo */
				mov.l	addr_sta_inh, r1
				jsr		@r1
				
		/* ---- ݎsĂяo */
				mov.l	addr_exe_inh, r1
				jsr		@r1
				mov		r9, r4						/* ݔԍƂ(xXbg) */
				
		/* ---- X^bN̕A */
				mov		r12, r15
				
		/* ---- ݃JE^̃NA */
				xor		r0, r0
				mov.b	r0, @(ICTXCB_INTCNT, r10)
				
		/* ---- ݃}XNlA */
				mov.l	@(4, r15), r0				/* ݑO sr o */
				and		#0xf0, r0					/* ݃}XNlo */
				cmp/eq	r0, r11						/* Â݃}XNlƔr */
				bf/s	return_int					/* svȂɊݏƂ݂Ȃ */
				mov.w	r3, @(ICTXCB_IMSK, r10)		/* ݑȌԂɊ݃}XNlݒ(xXbg) */
				
		/* ---- ݏIĂяo */
				resbank
				mov.l	r0, @-r15
				mov.l	r1, @-r15
				mov.l	r2, @-r15
				mov.l	r3, @-r15
				mov.l	r4, @-r15
				mov.l	r5, @-r15
				mov.l	r6, @-r15
				mov.l	r7, @-r15
				sts.l	pr, @-r15
				sts.l	fpscr, @-r15
				sts.l	fpul, @-r15
				fmov.d	dr0, @-r15
				fmov.d	dr2, @-r15
				fmov.d	dr4, @-r15
				fmov.d	dr6, @-r15
				fmov.d	dr8, @-r15
				fmov.d	dr10, @-r15
				
				mov.l	addr_end_inh, r2
				jsr		@r2
				
		/* ---- A݃}XN̐ݒ */
				mov.l	@(96, r15), r0		/* ݑO sr o */
				or		#0xf0, r0			/* ݃}XNNȂO(Urbg𗧂Ă) */
				mov.l	addr_ictxcb, r1
				xor		#0xf0, r0			/* ݃}XNNA(ĂƂĔ]) */
				mov.w	@r1, r1				/* }XNl擾 */
				or		r1, r0				/* }XNlݒ */
				mov.l	r0, @(96, r15)		/* ASR̐ݒ */
				
				fmov.d	@r15+, dr0
				fmov.d	@r15+, dr2
				fmov.d	@r15+, dr4
				fmov.d	@r15+, dr6
				fmov.d	@r15+, dr8
				fmov.d	@r15+, dr10
				lds.l	@r15+, fpul
				lds.l	@r15+, fpscr
				lds.l	@r15+, pr
				mov.l	@r15+, r7
				mov.l	@r15+, r6
				mov.l	@r15+, r5
				mov.l	@r15+, r4
				mov.l	@r15+, r3
				mov.l	@r15+, r2
				mov.l	@r15+, r1
				mov.l	@r15+, r0
				
				rte
				nop
				
				
		/* ---- A */
return_int:
				resbank
				rte
				nop



		/* ==== d݂̏ */
				.ALIGN	4
multiple_int:
		/* ---- ݎsĂяo */
				mov.l	addr_exe_inh, r1
				jsr		@r1					/* ݔԍ(r4)Ƃ */
				mov.l	r3, @-r15			/* Â}XNlۑ */
				
		/* ---- ݃JE^̌Z */
				mov.l	addr_ictxcb, r1
				mov.b	@(ICTXCB_INTCNT, r1), r0
				add		#-1, r0
				mov.b	r0, @(ICTXCB_INTCNT, r1)
				
		/* ---- ݃}XNl̕A */
				mov.l	@r15+, r3			/* Â}XNl𕜋A */
				bra		return_int
				mov.w	r3, @r1


				.align	2
addr_ictxcb:
				.long	__kernel_ictxcb			/* ݃ReLXgubN */

addr_sta_inh:
				.long	__kernel_sta_inh		/* ݊Jn */

addr_exe_inh:
				.long	__kernel_exe_inh		/* ݎs */

addr_end_inh:
				.long	__kernel_end_inh		/* ݏI */

addr_ibnr:
				.long	0xfffe080e				/* IBNR */


				.end


/* end of file */
