/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kswi_ctx.c
 * @brief %jp{ReLXg}%en{context control}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"



/** %jp{sReLXg̐ؑ} */
void _kernel_swi_ctx(
		_KERNEL_T_CTXCB *ctxcb_now,		/* ݂̃ReLXg̕ۑ */
		_KERNEL_T_CTXCB *ctxcb_nxt)		/* VɎsReLXg */
{
	/* %jp{؂ւȂ炻̂܂} */
	if ( ctxcb_now == ctxcb_nxt )
	{
		return;
	}
	
	/* %jp{NeBJZNVɓ} */
	EnterCriticalSection(&_kernel_ictxcb.CriticalSection);
	
	/* %jp{sReLXg̓o^} */
	_kernel_ictxcb.runctxcb = ctxcb_nxt;
	
	/* ؂ւReLXg̊Jn */
	if ( ctxcb_nxt->blInterrupt )
	{
		SetEvent(ctxcb_nxt->hIntEvent);
	}
	else
	{
		SetEvent(ctxcb_nxt->hEvent);
	}
	
	/* ؂ւ҂ɓ */
	if ( ctxcb_now->blInterrupt )
	{
		/* %jp{NeBJZNVo} */
		LeaveCriticalSection(&_kernel_ictxcb.CriticalSection);

		WaitForSingleObject(ctxcb_now->hIntEvent, INFINITE);
	}
	else
	{
		/* %jp{NeBJZNVo} */
		LeaveCriticalSection(&_kernel_ictxcb.CriticalSection);

		WaitForSingleObject(ctxcb_now->hEvent, INFINITE);
	}
}	



/* end of file */
