; ---------------------------------------------------------------------------
;  HOS-V4 Advance
;     Intel 8086 LSI-C86 Small Model
;
;                                     Copyright (C) 1998-2006 by Project HOS
;                                     http://sourceforge.jp/projects/hos/
; ---------------------------------------------------------------------------


TEXT			CSEG


; -----------------------------------------------
;  %jp{荞݋֎~}
;  void _kernel_dis_int(void)
; -----------------------------------------------
_kernel_dis_int_::
				cli					; 荞݋֎~
				ret


; -----------------------------------------------
;  %jp{荞݋}
;  void _kernel_ena_int(void)
; -----------------------------------------------
_kernel_ena_int_::
				sti					; 荞݋
				ret


; -----------------------------------------------
;  Entry point
; -----------------------------------------------
ctx_entry:		
				mov		ax, dx		; sp[^1ݒ
				mov		bx, bp		; sp[^2ݒ
				jmp		cx			; sAhXɕ

; -----------------------------------------------
;  %jp{sReLXg̍쐬}
;  _kernel_cre_ctx(
;		_KERNEL_T_CTXCB *pk_ctxcb,		쐬ReLXg (ax)
;		VP              isp,			X^bN|C^ (bx)
;		FP              entry,			sAhX         (cx)
;		VP_INT          par1,			sp[^1    (dx)
;		VP_INT          par2)			sp[^2    ([sp+2].w)
; -----------------------------------------------
_kernel_cre_ctx_::
				sub		bx, 12
				mov		[bx], cx				; sAhX      [cx]
				mov		[bx+2], dx				; sp[^1 [dx]
				mov		dx, [sp+2]
				mov		[bx+4], dx				; sp[^2 [bp]
				mov		[bx+10].w, ctx_entry	; ^[AhX
				xchg	ax, bx
				mov		[bx], ax
				ret


; -----------------------------------------------
;  %jp{sReLXg̐ؑ}
;  void _kernel_swi_ctx(
;		_KERNEL_T_CTXCB *pk_ctxcb_nxt,			؂ւ̃ReLXg [ax]
;		_KERNEL_T_CTXCB *pk_ctxcb_now)			݂̃ReLXg       [bx]
; -----------------------------------------------
_kernel_swi_ctx_::
				push	di
				push	si
				push	bp
				push	dx
				push	cx
				mov		[bx], sp
		; ---- ̂܂ _kernel_sta_ctx ɑ

; -----------------------------------------------
;  %jp{sReLXg̊Jn}
;  void _kernel_sta_ctx(
;		_KERNEL_T_CTXCB *pk_ctxcb)				JnReLXg [ax]
; -----------------------------------------------
_kernel_sta_ctx_::
				mov		bx, ax
				mov		sp, [bx]
				pop		cx
				pop		dx
				pop		bp
				pop		si
				pop		di
				ret


; end of file
