/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  rcv_adtq.c
 * @brief %jp{񓯊f[^L[M}%en{Receive from Asynchronous Data Queue}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "core/adtq.h"



VP_INT _kernel_adtq_frcv_dat(_KERNEL_T_ADTQCB *adtqcb)
{
	_KERNEL_ADTQ_T_POSITION head;
	VP_INT                  *adtq;
	VP_INT                  data;

	/* %jp{擪ʒu擾} */
	head = _KERNEL_ADTQ_GET_HEAD(adtqcb);
	
	/* %jp{f[^o} */
	adtq = _KERNEL_ADTQ_GET_ADTQ(adtqcb);
	data = adtq[head];

	/* %jp{̖ʒuvZ} */
	if ( head < _KERNEL_ADTQ_GET_ADTQCNT(adtqcb) - 1 )
	{
		head++;
	}
	else
	{
		head = 0;
	}

	/* %jp{擪ʒuXV} */
	_KERNEL_ADTQ_SET_HEAD(adtqcb, head);
	
	return data;
}


/* end of file */
