/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  rcv_adtq.c
 * @brief %jp{񓯊f[^L[M}%en{Receive from Asynchronous Data Queue}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "core/adtq.h"



void _kernel_adtq_fsnd_dat(_KERNEL_T_ADTQCB *adtqcb, VP_INT data)
{
	_KERNEL_ADTQ_T_POSITION tail;
	_KERNEL_ADTQ_T_POSITION tail_next;
	VP_INT                  *adtq;

	/* %jp{ʒu擾} */
	tail = _KERNEL_ADTQ_GET_TAIL(adtqcb);

	/* %jp{̖ʒuvZ} */
	tail_next = tail + 1;
	if ( tail_next >= _KERNEL_ADTQ_GET_ADTQCNT(adtqcb) )
	{
		tail_next = 0;
	}
	
	/* %jp{f[^i[} */
	adtq = _KERNEL_ADTQ_GET_ADTQ(adtqcb);
	adtq[tail] = data;

	/* %jp{ʒuXV} */
	_KERNEL_ADTQ_SET_TAIL(adtqcb, tail_next);
}


/* end of file */

