/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  dsp_sus.c
 * @brief %jp{^XNTXyh}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


/** %jp{^XNTXyh} */
void _kernel_dsp_sus_tsk(_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TCB_PTR     tcb;
	_KERNEL_TSK_T_TSKSTAT tskstat;

	/* %jp{TCB擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{݂̏Ԃ擾} */
	tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
	
	/* %jp{݂̏Ԃ擾} */
	if ( !(tskstat & _KERNEL_TTS_WAI) )
	{
#if _KERNEL_RUNTSK_ON_RDQ
		/* %jp{fB[L[O} */
		_KERNEL_SYS_RMV_RDQ(tskhdl);
#else
		if ( tskhdl != _KERNEL_SYS_GET_RUNTSK() )
		{
			_KERNEL_SYS_RMV_RDQ(tskhdl);
		}
#endif
	}

	/* %jp{҂Ԃɐݒ} */
	tskstat |= _KERNEL_TTS_SUS;
	_KERNEL_TSK_SET_TSKSTAT(tcb, tskstat);
}



/* end of file */
