/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  dsp_ter.c
 * @brief %jp{^XNI}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


/** %jp{^XNI} */
void _kernel_dsp_ter_tsk(_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TCB_PTR		tcb;
	_KERNEL_TSK_T_TSKSTAT	tskstat;

	/* %jp{TCB擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{݂̏Ԃ擾} */
	tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);

	if ( tskstat == _KERNEL_TTS_RDY )
	{
		/* %jp{fB[L[폜} */
		_KERNEL_SYS_RMV_RDQ(tskhdl);
	}
	else
	{
		/* ҂L[O */
		_KERNEL_SYS_RMV_TOQ(tskhdl);
		_KERNEL_TRM_QUE(tskhdl);
	}

	/* %jp{x~Ԃɐݒ} */
	_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_DMT);	
}



/* end of file */
