/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  dsp_tsk.c
 * @brief %en{Task dispatch}%jp{^XNfBXpb`}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"



/** %jp{^XNfBXpb`}%en{Task dispatch}
 * @return void
 */
void _kernel_dsp_tsk(void)
{
	_KERNEL_T_TSKHDL tskhdl_run;
	_KERNEL_T_TSKHDL tskhdl_top;
	_KERNEL_T_CTXCB  *ctxcb_run;
	_KERNEL_T_CTXCB  *ctxcb_top;
	
	/* %jp{^XNfBXpb`sȂۗĔ} */
	if ( _KERNEL_SYS_SNS_DPN() )
	{
		_KERNEL_SYS_SET_DLY();
		return;
	}
	_KERNEL_SYS_CLR_DLY();
	
	/* %jp{^XNnh擾} */
	tskhdl_top = _KERNEL_SYS_REF_RDQ();		/* %jp{fB[L[擪^XN擾} */
	tskhdl_run = _KERNEL_SYS_GET_RUNTSK();	/* %jp{s^XN擾} */
	
	if ( tskhdl_top == tskhdl_run )
	{
		return;
	}
	
	/* %jp{ReLXg擾} */
#if _KERNEL_SYSTSK_TCB

	ctxcb_top = _KERNEL_TSK_GET_CTXCB(_KERNEL_TSK_TSKHDL2TCB(tskhdl_top));	/* %jp{fB[L[擪^XÑReLXg擾} */
	ctxcb_run = _KERNEL_TSK_GET_CTXCB(_KERNEL_TSK_TSKHDL2TCB(tskhdl_run));	/* %jp{s^XÑReLXg擾} */

#else

	/* %jp{fB[L[擪^XÑReLXg擾} */
	if ( tskhdl_top != _KERNEL_TSKHDL_NULL )
	{
		ctxcb_top = _KERNEL_TSK_GET_CTXCB(_KERNEL_TSK_TSKHDL2TCB(tskhdl_top));
	}
	else
	{
		ctxcb_top = _KERNEL_SYS_GET_SYSCTXCB();
	}

	/* %jp{s^XÑReLXg擾} */
	if ( tskhdl_run != _KERNEL_TSKHDL_NULL )
	{
		ctxcb_run = _KERNEL_TSK_GET_CTXCB(_KERNEL_TSK_TSKHDL2TCB(tskhdl_run));
	}
	else
	{
		ctxcb_run = _KERNEL_SYS_GET_SYSCTXCB();
	}


#endif
	
	/* %jp{s^XN̓o^} */
	_KERNEL_SYS_SET_RUNTSK(tskhdl_top);
	
	/* %jp{^XNXCb`̃tbN} */
#if _KERNEL_SPT_HOK_TSKSWI
	{
		ID	tskid_old;
		ID	tskid_new;
		tskid_old = (tskhdl_run != _KERNEL_TSKHDL_NULL) ? _KERNEL_TSK_TSKHDL2ID(tskhdl_run) : 0;
		tskid_new = (tskhdl_top != _KERNEL_TSKHDL_NULL) ? _KERNEL_TSK_TSKHDL2ID(tskhdl_top) : 0;
		_kernel_tsk_swi(tskid_old, tskid_new);
	}
#endif
	
	/* %jp{fBXpb`s} */
	_KERNEL_SWI_CTX(ctxcb_run, ctxcb_top);
	
	/* %jp{^XNO} */
#if _KERNEL_SPT_TEX
	if ( tskhdl_run != _KERNEL_TSKHDL_NULL )
	{
		_kernel_exe_tex(tskhdl_run);
	}
#endif
}


/* end of file */
