/**
 *  Hyper Operating System V4 Advance
 *
 * @file  add_tmq.c
 * @brief %jp{^C}L[ɃIuWFNgǉ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "core/tmq.h"



/* ^C}IuWFNgXg폜 */
void _kernel_rmv_tmq(
		_KERNEL_T_TMQCB  *tmqcb,
		_KERNEL_T_TIMOBJ *pk_timobj)
{
	/* %jp{o^Ȃ牽Ȃ} */
	if ( pk_timobj->next == NULL )
	{
		return;
	}
	
	/* %jp{IuWFNǧĂяoȂ} */
	if ( pk_timobj == tmqcb->busy )
	{
		tmqcb->busy = NULL;
	}
	
	/* %jp{̃^C}Ȃ|C^炷} */
	if ( pk_timobj == tmqcb->next )
	{
		tmqcb->next = pk_timobj->next;		/* %jp{̃IuWFNgɈړ} */
	}
	
	/* %jp{Xg폜} */
	if ( pk_timobj == pk_timobj->next )
	{
		/* %jp{XgɂȂꍇ} */
		tmqcb->head = NULL;
		tmqcb->next = NULL;
	}
	else
	{
		/* %jp{擪Ȃ擪ʒu炷} */
		if ( pk_timobj == tmqcb->head )
		{
			tmqcb->head = pk_timobj->next;
		}
		
		/* %jp{Xg폜} */
		pk_timobj->next->prev = pk_timobj->prev;
		pk_timobj->prev->next = pk_timobj->next;
	}
	
	/* %jp{o^ɐݒ} */
	pk_timobj->next = NULL;
}


/* end of file */
