/**
 *  Hyper Operating System V4 Advance
 *
 * @file  add_tmq.c
 * @brief %jp{^C}L[ɃIuWFNgǉ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "core/tmq.h"



/* ^C}IuWFNg̎Ԃi߂ */
void _kernel_sig_tmq(
		_KERNEL_T_TMQCB *tmqcb,
		RELTIM          tictim)
{
	_KERNEL_T_TIMOBJ *timobj;
	
	/* ^C}IuWFNg̃nhĂяo */
	if ( tmqcb->head != NULL )
	{
		/* |C^ݒ */
		tmqcb->next = tmqcb->head;
		
		do /* Xg܂ŌJԂ */
		{
			timobj      = tmqcb->next;
			tmqcb->busy = timobj->next;		/* %jp{IuWFNgݒ} */
			tmqcb->next = timobj->next;		/* %jp{̃|C^Oɐݒ} */
			
			if ( timobj->lefttim > tictim )
			{
				/* %jp{cԌZ} */
				timobj->lefttim -= tictim;
			}
			else
			{
				/* %jp{^C}nhĂяo} */
				timobj->timhdr(timobj, tictim - timobj->lefttim);
				if ( tmqcb->next == NULL )
				{
					break;
				}
			}
		} while ( tmqcb->next != tmqcb->head );
		
		/* |C^̃NA */
		tmqcb->next = NULL;
		tmqcb->busy = NULL;
	}
}


/* end of file */
