/**
 *  Hyper Operating System V4 Advance
 *
 * @file  sig_toq.c
 * @brief %jp{^XN^CAEgL[ɒǉ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_TOQ

/* ^CAEgɃ^CeBbN */
void _kernel_sig_toq(
		_KERNEL_T_TOQCB *toqcb,
		RELTIM          tictim)		/* ǉ^CeBbN */
{
	_KERNEL_T_TSKHDL tskhdl_next;
	_KERNEL_T_TSKHDL tskhdl_prev;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_TCB    *tcb_next;
	_KERNEL_T_TCB    *tcb_prev;
	_KERNEL_TSK_T_RELTIM diftim;

	/* %jp{擪^XN擾} */
	tskhdl = _KERNEL_TOQ_GET_HEAD(toqcb);

	/* %jp{^CAEgL[Ȃ烊^[} */
	if ( tskhdl == _KERNEL_TSKHDL_NULL )
	{
		return;
	}

	/* %jp{^CAEgL[̏} */
	for ( ; ; )
	{
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

		diftim = _KERNEL_TSK_GET_TOQDIFTIM(tcb);
		
		/* %jp{^CAEgɒBȂȂ} */
		if ( diftim > tictim )
		{
			_KERNEL_TSK_SET_TOQDIFTIM(tcb, diftim - tictim);		/* %jp{^CAEgԂZ} */
			break;
		}
		
		tictim -= diftim;			/* %jp{^CeBbNZ} */
		
		_KERNEL_TSK_SET_ERCD(tcb, E_TMOUT);
		_KERNEL_DSP_WUP_TSK(tskhdl);

		_KERNEL_DSP_TSK();			/* %jp{xfBXpb`\s} */
		
		/* %jp{L[O} */
		tskhdl_next = _KERNEL_TSK_GET_TOQNEXT(tcb);
		tcb_next    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_next);
		tskhdl_prev = _KERNEL_TSK_GET_TOQPREV(tcb);
		tcb_prev    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_prev);
		if ( tskhdl_next == tskhdl )	/* %jp{Ō̂PȂ} */
		{
			/* %jp{L[ɂ} */
			_KERNEL_TSK_SET_TOQPREV(tcb, _KERNEL_TSKHDL_NULL);
			tskhdl = _KERNEL_TSKHDL_NULL;
			break;
		}
		
		/* %jp{L[O} */
		_KERNEL_TSK_SET_TOQNEXT(tcb_prev, tskhdl_next);
		_KERNEL_TSK_SET_TOQPREV(tcb_next, tskhdl_prev);
		_KERNEL_TSK_SET_TOQPREV(tcb, _KERNEL_TSKHDL_NULL);
		
		tskhdl = tskhdl_next;
		tcb    = tcb_next;
		
		/* %jp{ňxAd݂̋@^ׂH} */
	}
	
	/* %jp{ɏ߂} */
	_KERNEL_TOQ_SET_HEAD(toqcb, tskhdl);
}

#endif	/* _KERNEL_SPT_TOQ */


/* end of file */
