/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_cyc.c
 * @brief %jp{nh̐(IDԍt)}%en{Create cyclic handler(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/cycobj.h"



#if _KERNEL_SPT_CRE_CYC

/** %jp{nh̐(IDԍt)}%en{Create cyclic handler(ID Number Automatic Assignment)}
 * @param  cycid		%jp{Ώۂ̎nhIDԍ}%en{ID number of the cyclic handler to be created}
 * @param  pk_ccyc	    %jp{nhꂽpPbgւ̃|C^}%en{Pointer to the packet containing the cyclic handler creation information}
 * @retval %jp{̒l}%en{positiv-value} %jp{nhIDԍ}%en{ID number of the created cyclic handler}
 * @retval E_NOID  %jp{IDԍs(t\ȎnhID)}%en{No ID number available(there id no cyclic handler ID assignable)}
 * @retval E_RSATR %jp{\񑮐(cycatrs邢͎gpłȂ)}%en{Reserved attribute(cycatr is invalid or unusable)}
 */
ID cre_cyc(ID cycid, const T_CCYC *pk_ccyc)
{
	ER_ID erid;
	
	/* %jp{ID`FbN}%en{check ID} */
#if _KERNEL_SPT_CRE_CYC_E_ID
	if ( !_KERNEL_CYC_CHECK_CYCID(cycid) )
	{
		return E_ID;	/* %jp{sIDԍ}%en{Invalid ID number} */
	}	
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{݃`FbN}%en{check object} */
#if _KERNEL_SPT_CRE_CYC_E_OBJ
	if ( _KERNEL_CYC_CHECK_EXS(cycid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_OBJ;			/* %jp{IuWFNgԃG[}%en{Object state error} */
	}
#endif
	
	/* %jp{IuWFNg} */
#if (_KERNEL_CYCCB_ALGORITHM == _KERNEL_CYCCB_ALG_PTRARRAY) && _KERNEL_SPT_ACRE_CYC_E_NOMEM
	erid = (ER_ID)_kernel_cre_cyc(cycid, pk_ccyc);
	if ( erid == E_OK )
	{
		erid = (ER_ID)cycid;	/* %jp{G[łȂΎnhIDi[} */
	}
#else
	_kernel_cre_cyc(cycid, pk_ccyc);
	erid = (ER_ID)cycid;		/* %jp{nhIDi[} */
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_CYC */


#if _KERNEL_SPT_ACRE_CYC_E_NOSPT


/** %jp{nh̐(IDԍt)}%en{Create cyclic handler(ID Number Automatic Assignment)}
 * @param  pk_ccyc  %jp{nhꂽpPbgւ̃|C^}%en{Pointer to the packet containing the cyclic handler creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ID cre_cyc(ID cycid, const T_CCYC *pk_ccyc)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_CYC */



/* end of file */
