/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ref_cyc.c
 * @brief %jp{nh̏ԎQ}%en{Reference Cyclic Handler State}
 *
 * Copyright (C) 1998-2010 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/cycobj.h"



#if _KERNEL_SPT_REF_CYC


/** %jp{nh̏ԎQ}%en{Reference Cyclic Handler State}
 * @param  cycid    %jp{lΏۂ̎nhIDԍ}%en{ID number of the cycaphore from which resource is acquired}
 * @param  pk_rcyc  %jp{nhԂԂpPbgւ̃|C^}%en{Pointer to the packet returning the cycaphore state}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(cycids邢͎gpłȂ)}%en{Invalid ID number(cycid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(Ώێnho^)}%en{Non-existant object(specified cycaphore is not registerd)}
 * @retval E_PAR    %jp{p[^G[(pk_rcycs)}%en{Parameter error(pk_rcyc is invalid)}
 */
ER ref_cyc(ID cycid, T_RCYC *pk_rcyc)
{
	_KERNEL_T_CYCCB_PTR cyccb;
	
	/* %jp{ID ̃`FbN} */
#if _KERNEL_SPT_REF_CYC_E_ID
	if ( !_KERNEL_CYC_CHECK_CYCID(cycid) )
	{
		return E_ID;	/* %jp{sIDԍ}%en{Invalid ID number} */
	}
#endif
	
#if _KERNEL_SPT_REF_CYC_E_PAR
	if ( pk_rcyc == NULL )
	{
		return E_PAR;	/* %jp{p[^G[}%en{Parameter error} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_REF_CYC_E_NOEXS
	if ( !_KERNEL_CYC_CHECK_EXS(cycid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOEXS;			/* %jp{IuWFNg}%en{Non-existant object} */
	}
#endif

	/* %jp{nhRg[ubN擾} */
	cyccb    = _KERNEL_CYC_ID2CYCCB(cycid);
	
	/* %jp{擾} */
	if( _KERNEL_CYC_GET_TIMOBJ(cyccb)->next == NULL)
	{
		pk_rcyc->cycatr = TCYC_STP;
	}
	else
	{
		pk_rcyc->cycatr = TCYC_STA;
	}
	pk_rcyc->lefttim = _KERNEL_TIMOBJ_GET_LEFTTIM( _KERNEL_CYC_GET_TIMOBJ(cyccb) );
	

	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */	
	
	return E_OK;
}


#else	/* _KERNEL_SPT_REF_CYC */


#if _KERNEL_SPT_REF_CYC_E_NOSPT

/** %jp{nh̊l(|[O)}%en{Acquire Cyclic Handler Resource(Polling)}
 * @param  cycid    %jp{lΏۂ̎nhIDԍ}%en{ID number of the cycaphore from which resource is acquired}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER ref_cyc(ID cycid, T_RCYC *pk_rcyc)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_REF_CYC */



/* end of file */
