/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ipsnd_dt.c
 * @brief %jp{f[^L[ւ̑M(|[O ^XNReLXgp)}%en{Send to Data Queue}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/dtqobj.h"



#if _KERNEL_SPT_IPSND_DTQ

#if _KERNEL_SPT_DPC

static void _kernel_dpc_psnd_dtq(ID dtqid, VP_INT data);

/** %jp{f[^L[ւ̑M}%en{Send to Data Queue}
 * @param  dtqid    %jp{MΏۂ̃f[^L[IDԍ}%en{ID number of the data queue to which the data element is sent}
 * @param  data     %jp{f[^L[֑Mf[^}%en{Data element tobe sent}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(dtqids邢͎gpłȂ)}%en{Invalid ID number(dtqid is invalid or unusable)}
 * @retval E_NOMEM  %jp{xsp̃L[COs}%en{Insufficient memory to store a service call for delayed execution}
 */
ER ipsnd_dtq(ID dtqid, VP_INT data)
{
	/* %jp{ID ̃`FbN} */
#if _KERNEL_SPT_IPSND_DTQ_E_ID
	if ( !_KERNEL_DTQ_CHECK_DTQID(dtqid) )
	{
		return E_ID;	/* %jp{sIDԍ}%en{Invalid ID number} */
	}
#endif
	
	return _KERNEL_SYS_REQ_DPC(_kernel_dpc_psnd_dtq, dtqid, data);
}


void _kernel_dpc_psnd_dtq(ID dtqid, VP_INT data)
{
	_KERNEL_T_DTQCB  *dtqcb;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;
	

	/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_SND_DTQ_E_NOEXS
	if ( !_KERNEL_DTQ_CHECK_EXS(dtqid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
		return;					/* %jp{IuWFNg} */
	}
#endif
	
	/* %jp{f[^L[Rg[ubN擾} */
	dtqcb = _KERNEL_DTQ_ID2DTQCB(dtqid);
	
	/* %jp{M҂s擪^XNo} */
	tskhdl = _KERNEL_DTQ_RMH_RQUE(dtqcb);
	if ( tskhdl != _KERNEL_TSKHDL_NULL )
	{
		VP_INT *p_data;

		/* %jp{҂^XNΑ҂} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB擾} */
		_KERNEL_TSK_SET_ERCD(tcb, E_OK);			/* %jp{G[R[hݒ} */
		p_data = (VP_INT *)_KERNEL_TSK_GET_DATA(tcb);
		*p_data = data;
		_KERNEL_DSP_WUP_TSK(tskhdl);				/* %jp{^XN̑҂} */
		_KERNEL_DTQ_RMV_RTOQ(tskhdl);
	}
	else
	{
		const _KERNEL_T_DTQCB_RO *dtqcb_ro;
		_KERNEL_DTQ_T_DTQCNT     sdtqcnt;
		_KERNEL_DTQ_T_DTQCNT     dtqcnt;
		
		/* %jp{RO擾} */
		dtqcb_ro = _KERNEL_DTQ_GET_DTQCB_RO(dtqid, dtqcb);

		/* %jp{f[^L[JE^擾} */
		sdtqcnt = _KERNEL_DTQ_GET_SDTQCNT(dtqcb);
		dtqcnt  = _KERNEL_DTQ_GET_DTQCNT(dtqcb_ro);

		if ( sdtqcnt < dtqcnt )		/* %jp{L[ɋ󂫂͂邩H} */
		{
			_KERNEL_DTQ_T_DTQCNT head;
			VP_INT               *dtq;

			/* %jp{f[^L[擾} */
			head = _KERNEL_DTQ_GET_HEAD(dtqcb);
			dtq  = _KERNEL_DTQ_GET_DTQ(dtqcb_ro);

			/* %jp{f[^L[ɒǉ} */
			if ( head < dtqcnt - sdtqcnt - 1 )
			{
				dtq[head + sdtqcnt] = data;
			}
			else
			{
				dtq[head + sdtqcnt - dtqcnt] = data;
			}
			
			/* %jp{f[^Z} */
			sdtqcnt++;
			_KERNEL_DTQ_SET_SDTQCNT(dtqcb, sdtqcnt);
		}
	}
}


#else	/* _KERNEL_SPT_DPC */

/** %jp{f[^L[ւ̑M(|[O ^XNReLXgp)}%en{Send to Data Queue}
 * @param  dtqid    %jp{MΏۂ̃f[^L[IDԍ}%en{ID number of the data queue to which the data element is sent}
 * @param  data     %jp{f[^L[֑Mf[^}%en{Data element tobe sent}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(dtqids邢͎gpłȂ)}%en{Invalid ID number(dtqid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(Ώۃf[^L[o^)}%en{Non-existant object(specified data queue is not registerd)}
 * @retval E_TMOUT  %jp{|[Os}%en{Polling failure}
 */
ER ipsnd_dtq(ID dtqid, VP_INT data)
{
	return psnd_dtq(dtqid, data);
}

#endif	/* _KERNEL_SPT_DPC */




#else	/* _KERNEL_SPT_IPSND_DTQ */


#if _KERNEL_SPT_SND_DTQ_E_NOSPT

/** %jp{f[^L[ւ̑M}%en{Send to Data Queue}
 * @param  dtqid    %jp{MΏۂ̃f[^L[IDԍ}%en{ID number of the data queue to which the data element is sent}
 * @param  data     %jp{f[^L[֑Mf[^}%en{Data element tobe sent}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER ipsnd_dtq(ID dtqid, VP_INT data)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_SIPSND_DTQ */



/* end of file */
