/**
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_flg.c
 * @brief %jp{CxgtO̐(IDԍt)}%en{Create Eventflag(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_ACRE_FLG


/** %jp{CxgtO̐(IDԍt)}%en{Create Eventflag(ID Number Automatic Assignment)}
 * @param  pk_cflg	      %jp{CxgtOꂽpPbgւ̃|C^}%en{Pointer to the packet containing the eventflag creation information}
 * @retval %jp{̒l}%en{positiv-value} %jp{CxgtOIDԍ}%en{ID number of the created eventflag}
 * @retval E_NOID  %jp{IDԍs(t\ȃCxgtOID)}%en{No ID number available(there id no eventflag ID assignable)}
 * @retval E_RSATR %jp{\񑮐(flgatrs邢͎gpłȂ)}%en{Reserved attribute(flgatr is invalid or unusable)}
 */
ER_ID acre_flg(const T_CFLG *pk_cflg)
{
	ID    flgid;
	ER_ID erid;
	
	/* %jp{`FbN}%en{check attribute} */
#if _KERNEL_SPT_ACRE_FLG_E_RSATR
	if ( ((pk_cflg->flgatr & TA_TPRI) == 0 && !_KERNEL_SPT_FLG_TA_TFIFO)
		|| ((pk_cflg->flgatr & TA_TPRI) != 0 && !_KERNEL_SPT_FLG_TA_TPRI)
		|| ((pk_cflg->flgatr & TA_WMUL) == 0 && !_KERNEL_SPT_FLG_TA_WSGL)
		|| ((pk_cflg->flgatr & TA_WMUL) != 0 && !_KERNEL_SPT_FLG_TA_WMUL)
		|| ((pk_cflg->flgatr & TA_CLR)  != 0 && !_KERNEL_SPT_FLG_TA_CLR) )
	{
		return E_RSATR;	/* %jp{\񑮐}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{IDT} */
	for ( flgid = _KERNEL_FLG_TMAX_ID; flgid >= _KERNEL_FLG_TMIN_ID; flgid-- )
	{
		if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
		{
			break;
		}
	}

	/* %jp{IDT`FbN} */
#if _KERNEL_SPT_ACRE_SEM_E_NOID
	if ( flgid < _KERNEL_FLG_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOID;				/* %jp{IDԍs}%en{No ID number available} */
	}
#endif
	
	/* %jp{CxgtO} */
	erid = (ER_ID)_kernel_cre_flg(flgid, pk_cflg);
	if ( erid == E_OK )
	{
		erid = (ER_ID)flgid;
	}

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_FLG */


#if _KERNEL_SPT_ACRE_FLG_E_NOSPT

/** %jp{CxgtO̐(IDԍt)}%en{Create Eventflag(ID Number Automatic Assignment)}
 * @param  pk_cflg	      %jp{CxgtOꂽpPbgւ̃|C^}%en{Pointer to the packet containing the eventflag creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER_ID acre_flg(const T_CFLG *pk_cflg)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_FLG */



/* end of file */
