/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  clr_flg.c
 * @brief %jp{CxgtÕNA}%en{Clear Eventflag}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_CLR_FLG


/** %jp{CxgtÕNA}%en{Clear Eventflag}
 * @param  flgid    %jp{NAΏۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be cleared}
 * @param  clrptn   %jp{NArbgp^[(rbgƂ̔]l)}%en{Bit pattern to clear(bit-wise negated)}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(flgids邢͎gpłȂ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(ΏۃCxgtOo^)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{p[^G[(setptns)}%en{Parameter error(setptn is invalid)}
 */
ER clr_flg(ID flgid, FLGPTN clrptn)
{
	_KERNEL_T_FLGCB *flgcb;
	
	/* %jp{ID ̃`FbN} */
#if _KERNEL_SPT_CLR_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{IDs} */
	}
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{T[rXR[Jn} */
	
	/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_CLR_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
		return E_NOEXS;			/* %jp{IuWFNg} */
	}
#endif
	
	/* %jp{Rg[ubN擾} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);
	
	/* tONA */
	_KERNEL_FLG_SET_FLGPTN(flgcb, _KERNEL_FLG_GET_FLGPTN(flgcb) & clrptn);

	
	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
	
	return E_OK;	/* %jp{} */
}


#else	/* _KERNEL_SPT_CLR_FLG */


#if _KERNEL_SPT_CLR_FLG_E_NOSPT

/** %jp{CxgtÕNA}%en{Clear Eventflag}
 * @param  flgid    %jp{NAΏۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be cleared}
 * @param  clrptn   %jp{NArbgp^[(rbgƂ̔]l)}%en{Bit pattern to clear(bit-wise negated)}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER clr_flg(ID flgid, FLGPTN clrptn)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CLR_FLG */


/* end of file */
