/**
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_flg.c
 * @brief %jp{CxgtO̐}%en{Create Eventflag}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_CRE_FLG


/** %jp{CxgtO̐}%en{Create Eventflag}
 * @param  flgid    %jp{Ώۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be created}
 * @param  pk_cflg	%jp{CxgtOꂽpPbgւ̃|C^}%en{Pointer to the packet containing the eventflag creation information}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(semids邢͎gpłȂ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_RSATR  %jp{\񑮐(flgatrs邢͎gpłȂ)}%en{Reserved attribute(flgatr is invalid or unusable)}
 * @retval E_OBJ    %jp{IuWFNgԃG[(ΏۃCxgtOo^ς)}%en{Object state error(specified eventflag is already registerd)}
 */
ER cre_flg(ID flgid, const T_CFLG *pk_cflg)
{
	ER ercd;

	/* %jp{ID`FbN}%en{check ID} */
#if _KERNEL_SPT_CRE_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{sIDԍ}%en{Invalid ID number} */
	}	
#endif

	/* %jp{`FbN}%en{check attribute} */
#if _KERNEL_SPT_ACRE_FLG_E_RSATR
	if ( ((pk_cflg->flgatr & TA_TPRI) == 0 && !_KERNEL_SPT_FLG_TA_TFIFO)
		|| ((pk_cflg->flgatr & TA_TPRI) != 0 && !_KERNEL_SPT_FLG_TA_TPRI)
		|| ((pk_cflg->flgatr & TA_WMUL) == 0 && !_KERNEL_SPT_FLG_TA_WSGL)
		|| ((pk_cflg->flgatr & TA_WMUL) != 0 && !_KERNEL_SPT_FLG_TA_WMUL)
		|| ((pk_cflg->flgatr & TA_CLR)  != 0 && !_KERNEL_SPT_FLG_TA_CLR) )
	{
		return E_RSATR;	/* %jp{\񑮐}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{݃`FbN}%en{check object} */
#if _KERNEL_SPT_CRE_FLG_E_OBJ
	if ( _KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_OBJ;			/* %jp{IuWFNgԃG[}%en{Object state error} */
	}
#endif
	
	/* %jp{CxgtO} */
	ercd = _kernel_cre_flg(flgid, pk_cflg);

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return ercd;
}


#else	/* _KERNEL_SPT_CRE_FLG */


#if _KERNEL_SPT_CRE_FLG_E_NOSPT

/** %jp{CxgtO̐}%en{Create Eventflag}
 * @param  flgid    %jp{Ώۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be created}
 * @param  pk_cflg	%jp{CxgtOꂽpPbgւ̃|C^}%en{Pointer to the packet containing the eventflag creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER cre_flg(const T_CFLG *pk_cflg)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CRE_FLG */



/* end of file */
