/**
 *  Hyper Operating System V4 Advance
 *
 * @file  sig_sem.c
 * @brief %jp{Z}tH̕ԋp}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



/* %jp{tON𖞂Ă邩`FbN} */
BOOL _kernel_chk_flg(
		_KERNEL_T_FLGCB  *flgcb,		/* %jp{Rg[ubN} */
		_KERNEL_T_FLGINF *pk_flginf)	/* %jp{҂tOpPbg̐擪Ԓn} */
{
	if ( pk_flginf->wfmode == TWF_ANDW )
	{
		/* %jp{AND҂} */
		return ((_KERNEL_FLG_GET_FLGPTN(flgcb) & pk_flginf->waiptn) == pk_flginf->waiptn);
	}
	else
	{
		/* %jp{OR҂} */
		return ((_KERNEL_FLG_GET_FLGPTN(flgcb) & pk_flginf->waiptn) != 0);
	}
}


/* end of file */
