/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  pol_flg.c
 * @brief %jp{CxgtO҂(|[O)}%en{Wait for Eventflag(Polling)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_POL_FLG


#if _KERNEL_SPT_TWAI_FLG && (_KERNEL_OPT_CODE_SIZE <= _KERNEL_OPT_SPEED)	/* %jp{twai_flgŁAR[hTCYDȂ} */

/** %jp{CxgtO҂(|[O)}%en{Wait for Eventflag(Polling)}
 * @param  flgid    %jp{҂Ώۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{҂rbgp^[}%en{Wait bit pattern}
 * @param  wfmode   %jp{҂[h}%en{Wait mode}
 * @param  p_flgptn %jp{҂̃rbgp^[̕ԋpAhX}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(flgids邢͎gpłȂ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(ΏۃCxgtOo^)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{p[^G[(waiptn, wfmode, p_flgptns)}%en{Parameter error(waiptn, wfmode, or p_flgptn is invalid)}
 * @retval E_TMOUT  %jp{|[Os}%en{Polling failure}
 * @retval E_DLT    %jp{҂IuWFNg̍폜(҂Ԃ̊ԂɑΏۃCxgtO폜)}%en{Waiting object deleted(eventflag is deleted waiting)}
 */
ER pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	/* %jp{twai_flg őpAR[hTCY팸} */
	return twai_flg(flgid, waiptn, wfmode, p_flgptn, TMO_POL);
}

#else

/** %jp{CxgtO҂}%en{Wait for Eventflag}
 * @param  flgid    %jp{҂Ώۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{҂rbgp^[}%en{Wait bit pattern}
 * @param  wfmode   %jp{҂[h}%en{Wait mode}
 * @param  p_flgptn %jp{҂̃rbgp^[̕ԋpAhX}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(flgids邢͎gpłȂ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(ΏۃCxgtOo^)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{p[^G[(waiptn, wfmode, p_flgptns)}%en{Parameter error(waiptn, wfmode, or p_flgptn is invalid)}
 * @retval E_TMOUT  %jp{|[Os}%en{Polling failure}
 * @retval E_DLT    %jp{҂IuWFNg̍폜(҂Ԃ̊ԂɑΏۃCxgtO폜)}%en{Waiting object deleted(eventflag is deleted waiting)}
 */
ER pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	_KERNEL_T_FLGCB          *flgcb;
	_KERNEL_T_FLGINF         flginf;
	ER                       ercd;

	/* %jp{ID ̃`FbN} */
#if _KERNEL_SPT_POL_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{IDs} */
	}
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[Jn} */
	
	/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_POL_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
		return E_NOEXS;			/* %jp{IuWFNg} */
	}
#endif
	
	
	/* %jp{Rg[ubN擾} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);
	
	/* %jp{҂ݒ} */
	flginf.waiptn = waiptn;
	flginf.wfmode = wfmode;
	
	/* %jp{tO`FbN} */
	if ( _kernel_chk_flg(flgcb, &flginf) )
	{
		/* %jp{ɏ𖞂ĂȂ} */
		*p_flgptn = _KERNEL_FLG_GET_FLGPTN(flgcb);			/* %jp{̃tOp^[i[} */

#if _KERNEL_SPT_FLG_TA_CLR
		if ( _KERNEL_FLG_GET_FLGATR(_KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb)) & TA_CLR )
		{
			_KERNEL_FLG_SET_FLGPTN(flgcb, 0);		/* %jp{NA΃NA} */
		}
#endif
		
		ercd = E_OK;
	}
	else
	{
		ercd = E_TMOUT;
	}
		
	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
	
	return ercd;	/*  */
}

#endif


#else	/* _KERNEL_SPT_POL_FLG */


#if _KERNEL_SPT_POL_FLG_E_NOSPT

/** %jp{CxgtO҂}%en{Wait for Eventflag}
 * @param  flgid    %jp{҂Ώۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{҂rbgp^[}%en{Wait bit pattern}
 * @param  wfmode   %jp{҂[h}%en{Wait mode}
 * @param  p_flgptn %jp{҂̃rbgp^[̕ԋpAhX}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	return E_NOSPT;
}

#endif

#endif	/* _KERNEL_SPT_POL_FLG */


/* end of file */
