/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  wai_flg.c
 * @brief %jp{CxgtO҂}%en{Wait for Eventflag}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_WAI_FLG


#if _KERNEL_SPT_TWAI_FLG && (_KERNEL_OPT_CODE_SIZE <= _KERNEL_OPT_SPEED)	/* %jp{twai_flgŁATCYDȂ} */

/** %jp{CxgtO҂}%en{Wait for Eventflag}
 * @param  flgid    %jp{҂Ώۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{҂rbgp^[}%en{Wait bit pattern}
 * @param  wfmode   %jp{҂[h}%en{Wait mode}
 * @param  p_flgptn %jp{҂̃rbgp^[̕ԋpAhX}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(flgids邢͎gpłȂ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(ΏۃCxgtOo^)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{p[^G[(waiptn, wfmode, p_flgptns)}%en{Parameter error(waiptn, wfmode, or p_flgptn is invalid)}
 * @retval E_ILUSE  %jp{T[rXR[sgpiTA_WSGLw肳ꂽCxgtOő҂^XN}%en{Illegal service call use(there is already a task waiting for an eventflag with tahe TA_WSGL attribute)}
 * @retval E_RLWAI  %jp{҂Ԃ̋(҂Ԃ̊Ԃrel_wait)}%en{Forced release from waiting(accept rel_wai while waiting)}
 * @retval E_DLT    %jp{҂IuWFNg̍폜(҂Ԃ̊ԂɑΏۃCxgtO폜)}%en{Waiting object deleted(eventflag is deleted waiting)}
 */
ER wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	return twai_flg(flgid, waiptn, wfmode, p_flgptn, TMO_FEVR);
}

#else

/** %jp{CxgtO҂}%en{Wait for Eventflag}
 * @param  flgid    %jp{҂Ώۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{҂rbgp^[}%en{Wait bit pattern}
 * @param  wfmode   %jp{҂[h}%en{Wait mode}
 * @param  p_flgptn %jp{҂̃rbgp^[̕ԋpAhX}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(flgids邢͎gpłȂ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_CTX    %jp{ReLXgG[}%en{Context error}
 * @retval E_NOEXS  %jp{IuWFNg(ΏۃCxgtOo^)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{p[^G[(waiptn, wfmode, p_flgptns)}%en{Parameter error(waiptn, wfmode, or p_flgptn is invalid)}
 * @retval E_ILUSE  %jp{T[rXR[sgpiTA_WSGLw肳ꂽCxgtOő҂^XN}%en{Illegal service call use(there is already a task waiting for an eventflag with tahe TA_WSGL attribute)}
 * @retval E_RLWAI  %jp{҂Ԃ̋(҂Ԃ̊Ԃrel_wait)}%en{Forced release from waiting(accept rel_wai while waiting)}
 * @retval E_DLT    %jp{҂IuWFNg̍폜(҂Ԃ̊ԂɑΏۃCxgtO폜)}%en{Waiting object deleted(eventflag is deleted waiting)}
 */
ER wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	_KERNEL_T_FLGCB  *flgcb;
	_KERNEL_T_FLGINF flginf;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;
	ER               ercd;

	/* %jp{ReLXg`FbN} */
#if _KERNEL_SPT_WAI_FLG_E_CTX
	if ( _KERNEL_SYS_SNS_DPN() )
	{
		return E_CTX;			/* %jp{ReLXgG[}%en{Context error} */
	}
#endif

	/* %jp{ID ̃`FbN} */
#if _KERNEL_SPT_WAI_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{IDs} */
	}
#endif

	/* %jp{p[^̃`FbN} */
#if _KERNEL_SPT_WAI_FLG_E_PAR
	if ( waiptn == 0 )
	{
		return E_PAR;	/* %jp{p[^s} */
	}
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[Jn} */
	
	/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_WAI_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
		return E_NOEXS;			/* %jp{IuWFNg} */
	}
#endif
	
	/* %jp{Rg[ubN擾} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);

#if _KERNEL_SPT_WAI_FLG_E_ILUSE
	if ( !(_KERNEL_FLG_GET_FLGATR(_KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb)) & TA_WMUL)
			&& _KERNEL_REF_QUE(_KERNEL_FLG_GET_QUE(flgcb)) != _KERNEL_TSKHDL_NULL )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
		return E_ILUSE;
	}
#endif

	/* %jp{҂ݒ} */
	flginf.waiptn = waiptn;
	flginf.wfmode = wfmode;
	
	/* %jp{tO`FbN} */
	if ( _kernel_chk_flg(flgcb, &flginf) )
	{
		/* %jp{ɏ𖞂ĂȂ} */
		if ( p_flgptn != NULL )
		{
			*p_flgptn = _KERNEL_FLG_GET_FLGPTN(flgcb);		/* %jp{̃tOp^[i[} */
		}
		
#if _KERNEL_SPT_FLG_TA_CLR
		if ( _KERNEL_FLG_GET_FLGATR(_KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb)) & TA_CLR )
		{
			_KERNEL_FLG_SET_FLGPTN(flgcb, 0);		/* %jp{NA΃NA} */
		}
#endif
		
		ercd = E_OK;
	}
	else
	{
		/* %jp{^XN҂Ԃɂ} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();
		tcb    = _KERNEL_TSK_TSKHDL2TCB(tskhdl);			/* %jp{TCB擾} */
		_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_WAI);
		_KERNEL_TSK_SET_TSKWAIT(tcb, _KERNEL_TTW_SEM);
		_KERNEL_TSK_SET_WOBJID(tcb, flgid);
		_KERNEL_TSK_SET_DATA(tcb, (VP_INT)&flginf);
		
		_KERNEL_DSP_WAI_TSK(tskhdl);
		_KERNEL_FLG_ADD_QUE(flgcb, _KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb), tskhdl);		/* %jp{҂sɒǉ} */
		
		/* %jp{^XNfBXpb`̎s} */
		_KERNEL_DSP_TSK();

		/* %jp{G[R[h̎擾} */
		ercd = _KERNEL_TSK_GET_ERCD(tcb);

		/* %jp{𖞂ĉꂽ̂Ȃ} */
		if ( ercd == E_OK )
		{
			if ( p_flgptn != NULL )
			{
				*p_flgptn = flginf.waiptn;		/* %jp{̃tOp^[i[} */
			}
		}
	}
		
	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
	
	return ercd;	/*  */
}

#endif


#else	/* _KERNEL_SPT_WAI_FLG */


#if _KERNEL_SPT_WAI_FLG_E_NOSPT

/** %jp{CxgtO҂}%en{Wait for Eventflag}
 * @param  flgid    %jp{҂Ώۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{҂rbgp^[}%en{Wait bit pattern}
 * @param  wfmode   %jp{҂[h}%en{Wait mode}
 * @param  p_flgptn %jp{҂̃rbgp^[̕ԋpAhX}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	return E_NOSPT;
}

#endif

#endif	/* _KERNEL_SPT_WAI_FLG */


/* end of file */
