/**
 *  Hyper Operating System V4 Advance
 *
 * @file  sta_inte.c
 * @brief %jp{ݏJn}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/inhobj.h"


#if _KERNEL_SPT_DPC


/** %jp{ݏJn}
 * @return void
 */
void _kernel_end_inh(void)
{
	/* %jp{݃ReLXg𔲂} */
	_KERNEL_SYS_CLR_CTX();
	
	/* %jp{T[rXR[̒Ȃ牽Ȃ} */
	if ( _KERNEL_SYS_SNS_SVC() )
	{
		return;
	}
	
	/* %jp{^XNReLXgDPC} */
	_KERNEL_ENA_INT();			/* %jp{݋} */

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
		
	_KERNEL_DIS_INT();			/* %jp{݋֎~} */
}


#else


/** %jp{ݏJn}
 * @return void
 */
void _kernel_end_inh(void)
{
	/* %jp{݃ReLXg𔲂} */
	_KERNEL_SYS_CLR_CTX();
	
	/* %jp{xĂfBXpb`Ύ{} */
	if ( _KERNEL_SYS_SNS_DLY() )
	{
		_KERNEL_DSP_TSK();
	}
}

#endif


/* end of file */
