/**
 *  Hyper Operating System V4 Advance
 *
 * @file  exe_inh.c
 * @brief %jp{݃nh̏}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/inhobj.h"


/* %jp{݃nh̏} */
void _kernel_exe_inh(INHNO inhno)
{
	/* %jp{݃nh̏} */
#if _KERNEL_SPT_INH
	{
		const _KERNEL_T_INHINF *pk_inhinf;
	
		pk_inhinf = _KERNEL_INT_GET_INHINF(inhno);
	
		if ( pk_inhinf->inthdr != NULL )
		{
			_KERNEL_ENA_INT();			/* %jp{d݋} */
			pk_inhinf->inthdr();		/* %jp{݃nh̏} */
			_KERNEL_DIS_INT();			/* %jp{݋֎~} */
		}
	}
#endif
	
	/* %jp{݃Rg[̏} */
#if _KERNEL_SPT_ISR
	_KERNEL_EXE_IRC(inhno);
#endif

}


/* end of file */
