/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  del_mtx.c
 * @brief %jp{~[ebNX̍폜}%en{Delete Mutex}
 *
 * Copyright (C) 1998-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/mtxobj.h"



#if _KERNEL_SPT_DEL_MTX


/** %jp{~[ebNX̍폜}%en{Delete Mutex}
 * @param  mtxid    %jp{폜Ώۂ̃~[ebNXIDԍ}%en{ID number of the mutex to be deleted}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(mtxids邢͎gpłȂ)}%en{Invalid ID number(mtxid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(Ώۃ~[ebNXo^)}%en{Non-existant object(specified mutex is not registerd)}
 */
ER del_mtx(ID mtxid)
{
	_KERNEL_T_MTXCB  *mtxcb;
	_KERNEL_T_QUE    *pk_que;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;

	/* %jp{ID`FbN}%en{check ID} */
#if _KERNEL_SPT_DEL_MTX_E_ID
	if ( !_KERNEL_MTX_CHECK_MTXID(mtxid) )
	{
		return E_ID;	/* %jp{sIDԍ}%en{Invalid ID number} */
	}	
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{݃`FbN}%en{check object} */
#if _KERNEL_SPT_DEL_MTX_E_NOEXS
	if ( !_KERNEL_MTX_CHECK_EXS(mtxid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOEXS;			
	}
#endif
	
	/* %jp{~[ebNXRg[ubN擾} */
	mtxcb = _KERNEL_MTX_ID2MTXCB(mtxid);
	
	/* %jp{҂s擾} */
	pk_que = _KERNEL_MTX_GET_QUE(mtxcb);
	
	/* %jp{҂s̃^XNSċN} */
	while ( (tskhdl = _KERNEL_RMH_QUE(pk_que)) != _KERNEL_TSKHDL_NULL )
	{
		/* %jp{҂^XNΑ҂} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB擾} */
		_KERNEL_TSK_SET_ERCD(tcb, E_DLT);			/* %jp{G[R[hݒ} */
		_KERNEL_MTX_RMV_TOQ(tskhdl);				/* %jp{^CAEgL[O} */
		_KERNEL_DSP_WUP_TSK(tskhdl);				/* %jp{^XN̑҂} */	
	}
	
	/* %jp{IuWFNg폜} */
#if _KERNEL_MTXCB_ALGORITHM == _KERNEL_MTXCB_ALG_PTRARRAY
	_KERNEL_SYS_FRE_HEP(mtxcb);						/* %jp{J} */
	_KERNEL_MTX_ID2MTXCB(mtxid) = NULL;
#elif _KERNEL_MTXCB_ALGORITHM == _KERNEL_MTXCB_ALG_BLKARRAY
	_KERNEL_MTX_SET_MTXATR(mtxcb, 0);
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_DEL_MTX */


#if _KERNEL_SPT_DEL_MTX_E_NOSPT

/** %jp{~[ebNX̍폜}%en{Delete Mutex}
 * @param  mtxid    %jp{폜Ώۂ̃~[ebNXIDԍ}%en{ID number of the mutex to be deleted}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER del_mtx(ID mtxid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_DEL_MTX */



/* end of file */
