/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kadd_mtx.c
 * @brief %jp{~[ebNXTCBɐڑ}%en{}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mtxobj.h"


/**< %jp{^XN~[ebNXO} */
void _kernel_rmv_mtx(_KERNEL_T_MTXHDL mtxhdl, _KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_MTXCB_PTR		mtxcb;
	_KERNEL_T_TCB_PTR 		tcb;
	_KERNEL_T_MTXHDL		mtxhdl_head;
	_KERNEL_T_MTXHDL		mtxhdl_next;
	_KERNEL_T_MTXHDL		mtxhdl_prev;
	_KERNEL_T_MTXCB_PTR		mtxcb_next;
	_KERNEL_T_MTXCB_PTR		mtxcb_prev;
	
	mtxcb = _KERNEL_MTX_MTXHDL2MTXCB(mtxhdl);
	tcb   = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	_KERNEL_MTX_SET_TSKHDL(mtxcb, _KERNEL_TSKHDL_NULL);
	
	/* O */
	mtxhdl_next = _KERNEL_MTX_GET_NEXT(mtxcb);
	if ( mtxhdl_next == mtxhdl )
	{
		/* %jp{Ō̂PO} */
		_KERNEL_TSK_SET_MTXHDL(tcb, _KERNEL_MTXHDL_NULL);
	}
	else
	{
		/* %jp{O̐ڑ擾} */
		mtxcb_next  = _KERNEL_MTX_MTXHDL2MTXCB(mtxhdl_next);
		mtxhdl_prev = _KERNEL_MTX_GET_PREV(mtxcb_next);
		mtxcb_prev  = _KERNEL_MTX_MTXHDL2MTXCB(mtxhdl_prev);
		
		/* %jp{ڑ} */
		_KERNEL_MTX_SET_PREV(mtxcb_next, mtxhdl_prev);
		_KERNEL_MTX_SET_NEXT(mtxcb_prev, mtxhdl_next);
		
		/* %jp{擪Ȃ炸炷} */
		mtxhdl_head = _KERNEL_TSK_GET_MTXHDL(tcb);
		if ( mtxhdl_head == mtxhdl )
		{
			_KERNEL_TSK_SET_MTXHDL(tcb, mtxhdl_next);
		}
	}
	
	/* %jp{҂^XN΋N} */
	tskhdl = _KERNEL_MTX_RMH_QUE(mtxcb);
	if ( tskhdl != _KERNEL_TSKHDL_NULL )
	{
		/* %jp{TCB擾} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
		
		/* ~[ebNq */
		_kernel_add_mtx(mtxhdl, tskhdl);
		
		/* %jp{^XN҂} */
		_KERNEL_TSK_SET_ERCD(tcb, E_OK);			/* %jp{G[R[hݒ} */
		_KERNEL_DSP_WUP_TSK(tskhdl);				/* %jp{^XN̑҂} */
		_KERNEL_MTX_RMV_TOQ(tskhdl);
	}
}


/* end of file */
