/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_sem.c
 * @brief %jp{Z}tH̐(IDԍt)}%en{Create Semaphore(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/semobj.h"



#if _KERNEL_SPT_ACRE_SEM

/** %jp{Z}tH̐(IDԍt)}%en{Create Semaphore(ID Number Automatic Assignment)}
 * @param  pk_csem	      %jp{Z}tHꂽpPbgւ̃|C^}%en{Pointer to the packet containing the semaphore creation information}
 * @retval %jp{̒l}%en{positiv-value} %jp{Z}tHIDԍ}%en{ID number of the created semaphore}
 * @retval E_NOID  %jp{IDԍs(t\ȃZ}tHID)}%en{No ID number available(there id no semaphore ID assignable)}
 * @retval E_RSATR %jp{\񑮐(sematrs邢͎gpłȂ)}%en{Reserved attribute(sematr is invalid or unusable)}
 */
ER_ID acre_sem(const T_CSEM *pk_csem)
{
	ID    semid;
	ER_ID erid;

	/* %jp{`FbN}%en{check attribute} */
#if _KERNEL_SPT_ACRE_SEM_E_RSATR
	if ( ((pk_csem->sematr & TA_TPRI) == 0 && !_KERNEL_SPT_SEM_TA_TFIFO)
		|| ((pk_csem->sematr & TA_TPRI) != 0 && !_KERNEL_SPT_SEM_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{\񑮐}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{IDT} */
	for ( semid = _KERNEL_SEM_TMAX_ID; semid >= _KERNEL_SEM_TMIN_ID; semid-- )
	{
		if ( !_KERNEL_SEM_CHECK_EXS(semid) )
		{
			break;
		}
	}

	/* %jp{IDT`FbN} */
#if _KERNEL_SPT_ACRE_SEM_E_NOID
	if ( semid < _KERNEL_SEM_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOID;			/* %jp{IDԍs} */
	}
#endif
	
	/* %jp{IuWFNg} */
#if (_KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_PTRARRAY) && _KERNEL_SPT_ACRE_SEM_E_NOMEM
	erid = (ER_ID)_kernel_cre_sem(semid, pk_csem);
	if ( erid == E_OK )
	{
		erid = (ER_ID)semid;	/* %jp{G[łȂ΃Z}tHIDi[} */
	}
#else
	_kernel_cre_sem(semid, pk_csem);
	erid = (ER_ID)semid;		/* %jp{Z}tHIDi[} */
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_SEM */


#if _KERNEL_SPT_ACRE_SEM_E_NOSPT


/** %jp{Z}tH̐(IDԍt)}%en{Create Semaphore(ID Number Automatic Assignment)}
 * @param  pk_csem  %jp{Z}tHꂽpPbgւ̃|C^}%en{Pointer to the packet containing the semaphore creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER_ID acre_sem(const T_CSEM *pk_csem)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_SEM */



/* end of file */
