/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_sem.c
 * @brief %jp{Z}tH̐}%en{Create Semaphore}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/semobj.h"



#if _KERNEL_SPT_CRE_SEM


/** %jp{Z}tH̐}%en{Create Semaphore}
 * @param  semid    %jp{Ώۂ̃Z}tHIDԍ}%en{ID number of the semaphore to be created}
 * @param  pk_ctsk	%jp{Z}tHꂽpPbgւ̃|C^}%en{Pointer to the packet containing the semaphore creation information}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(semids邢͎gpłȂ)}%en{Invalid ID number(semid is invalid or unusable)}
 * @retval E_RSATR  %jp{\񑮐(sematrs邢͎gpłȂ)}%en{Reserved attribute(sematr is invalid or unusable)}
 * @retval E_OBJ    %jp{IuWFNgԃG[(ΏۃZ}tHo^ς)}%en{Object state error(specified semaphore is already registerd)}
 */
ER cre_sem(ID semid, const T_CSEM *pk_csem)
{
	ER ercd;

	/* %jp{ID`FbN}%en{check ID} */
#if _KERNEL_SPT_CRE_SEM_E_ID
	if ( !_KERNEL_SEM_CHECK_SEMID(semid) )
	{
		return E_ID;	/* %jp{sIDԍ}%en{Invalid ID number} */
	}	
#endif

	/* %jp{`FbN}%en{check attribute} */
#if _KERNEL_SPT_CRE_SEM_E_RSATR
	if ( ((pk_csem->sematr & TA_TPRI) == 0 && !_KERNEL_SPT_SEM_TA_TFIFO)
		|| ((pk_csem->sematr & TA_TPRI) != 0 && !_KERNEL_SPT_SEM_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{\񑮐}%en{Reserved attribute} */
	}
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{݃`FbN}%en{check object} */
#if _KERNEL_SPT_CRE_SEM_E_OBJ
	if ( _KERNEL_SEM_CHECK_EXS(semid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_OBJ;			/* %jp{IuWFNgԃG[}%en{Object state error} */
	}
#endif
	
	/* %jp{IuWFNg}%en{create object} */
	ercd = _kernel_cre_sem(semid, pk_csem);
	
	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
	
	return ercd;
}


#else	/* _KERNEL_SPT_CRE_SEM */


#if _KERNEL_SPT_CRE_SEM_E_NOSPT

/** %jp{Z}tH̐}%en{Create Semaphore}
 * @param  semid    %jp{Ώۂ̃Z}tHIDԍ}%en{ID number of the semaphore to be created}
 * @param  pk_ctsk	%jp{Z}tHꂽpPbgւ̃|C^}%en{Pointer to the packet containing the semaphore creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER cre_sem(ID semid, const T_CSEM *pk_csem)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CRE_SEM */



/* end of file */
