/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  sta_knl.c
 * @brief %en{Start Kernel}%jp{OS̋N}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"



/**** b̎蔲() *****/
#if _KERNEL_SPT_DPC
_KERNEL_T_DPCMSG dpc_buf[32];
#endif
/**** b̎蔲(܂) *****/




static void _kernel_sys_sta(void);		/** %jp{VXeReLXg̊Jn} */


/** %jp{J[l̊Jn(ƎT[rXR[)}%en{Start Kernel}
 * @return void
 */
ER vsta_knl(void)
{
	/* %jp{VXȅ} */
	_KERNEL_SYS_INI_SYS();
	
	/* %jp{vZbTŗL̏} */
	_KERNEL_INI_PRC();
	
	_KERNEL_ENTER_SVC();
	
	/* %jp{[`͔^XN} */
	_KERNEL_SYS_SET_CTX();
	_KERNEL_SYS_SET_LOC();
	
	/* %jp{IRCŗL̏} */
	_KERNEL_INI_IRC();
	
	/* %jp{nhs} */
	_kernel_cfg_ini();

#if _KERNEL_SPT_DPC
	_KERNEL_SYS_INI_DPC(dpc_buf, 32);
#endif
	
	/* %jp{VXeReLXg̐} */
	_KERNEL_CRE_CTX(
			_KERNEL_SYS_GET_SYSCTXCB(),
			_KERNEL_SYS_GET_SYSSTKSZ(),
			_KERNEL_SYS_GET_SYSSTK(),
			_KERNEL_SYS_GET_SYSISP(),
			(FP)_kernel_sys_sta,
			(VP_INT)0,
			(VP_INT)0
		);
	
	
	_KERNEL_LEAVE_SVC();
	
	/* %jp{nhs} */
	_kernel_cfg_sta();
	
	_KERNEL_ENTER_SVC();
	
	
	/* %jp{ReLXg̊Jn} */
	_kernel_sta_ctx(_KERNEL_SYS_GET_SYSCTXCB());
	
	return E_OK;	/* %jp{} */
}


/** %jp{VXeReLXg̊Jn} */
void _kernel_sys_sta(void)
{
	/* %jp{^XNԂɑJ} */
	_KERNEL_SYS_CLR_CTX();
	_KERNEL_SYS_CLR_LOC();
	_KERNEL_SYS_CLR_DSP();
	_KERNEL_SYS_CLR_SYS();
	
	/* %jp{DPCΉȂ炱Ŋ݋} */
#if _KERNEL_SPT_DPC
	_KERNEL_ENA_INT();
#endif
	
	/* %jp{^XNfBXpb`Jn} */
	_KERNEL_DSP_TSK();
	
	/* %jp{ȍ~VXeReLXgAChƂėp} */
	_KERNEL_LEAVE_SVC();
	_kernel_idl_lop();
}


/* end of file */
