/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_tsk.c
 * @brief %jp{^XN̐(IDԍt)}%en{Create Task(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


#if _KERNEL_SPT_ACRE_TSK


/** %jp{^XN̐}%en{Create Task}
 * @param  tskid	%jp{^XNID}%en{ID number of the task to be created}
 * @param  pk_ctsk	%jp{^XNꂽpPbgւ̃|C^}%en{Pointer to the packet containing the task creation information}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_NOID   %jp{IDԍs}%en{No ID number available}
 * @retval E_NOMEM	%jp{s}%en{Insufficient memory}
 * @retval E_PAR    %jp{p[^G[}%en{Perameter error}
 * @retval E_RSATR  %jp{\񑮐(tskatrs邢͎gpłȂ)}%en{Reserved attribute(tskatr is invalid or unusable)}
 */
ER_ID acre_tsk(
		const T_CTSK *pk_ctsk)
{
	ID    tskid;
	ER_ID erid;

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{IDT} */
#if _KERNEL_ACRE_TSK_ASCENDING_ORDER
	/* %jp{IDT} */
	for ( tskid = _KERNEL_TSK_TMIN_ID; tskid <= _KERNEL_TSK_TMAX_ID; tskid++ )
	{
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			break;
		}
	}
	if ( tskid > _KERNEL_TSK_TMAX_ID )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOID;				/* %jp{IDԍs}%en{No ID number available} */
	}
#else
	/* %jp{ID~T} */
	for ( tskid = _KERNEL_TSK_TMAX_ID; tskid >= _KERNEL_TSK_TMIN_ID; tskid-- )
	{
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			break;
		}
	}
	if ( tskid < _KERNEL_TSK_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOID;				/* %jp{IDԍs}%en{No ID number available} */
	}
#endif
	
	/* %jp{^XN} */
	erid = (ER_ID)_kernel_cre_tsk(tskid, pk_ctsk);
	if ( erid == E_OK )
	{
		erid = (ER_ID)tskid;
	}
	
	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return erid;
}



#else	/* _KERNEL_SPT_ACRE_TSK */


#if _KERNEL_SPT_ACRE_TSK_E_NOSPT

/** %jp{^XN̐}%en{Create Task}
 * @param  tskid	%jp{^XNID}%en{ID number of the task to be created}
 * @param  pk_ctsk	%jp{^XNꂽpPbgւ̃|C^}%en{Pointer to the packet containing the task creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER acre_tsk(
		const T_CTSK	*pk_ctsk)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_TSK */


/* end of file */
