/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  wup_tsk.c
 * @brief %jp{^XN̋N}%en{Wakeup Task}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


ER can_act(
		ID tskid)
{
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;

	if ( tskid == TSK_SELF )		/* %jp{^XNw莞̕ϊ} */
	{
#if _KERNEL_SPT_CAN_ACT_E_ID
		if ( _KERNEL_SYS_SNS_CTX() )
		{
			return E_ID;		/* %jp{sIDԍ} */
		}
#endif	
		/* %jp{s^XN擾} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();

		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{T[rXR[ɓ} */
	}
	else
	{
#if _KERNEL_SPT_CAN_ACT_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;	/* %jp{sIDԍ} */
		}
#endif
		
		_KERNEL_ENTER_SVC();			/* %jp{enter service-call}%jp{T[rXR[ɓ} */
		
		/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_CAN_ACT_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{T[rXR[o} */
			return E_NOEXS;			/* %jp{IuWFNg} */
		}
#endif
		/* IDԍw莞̕ϊ */
		tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	}
	
	/* %jp{TCB擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{҂JE^NA} */
	_KERNEL_TSK_SET_ACTCNT(tcb, 0);

	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */

	return E_OK;
}


/* end of file */
