/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  chg_pri.c
 * @brief %jp{^XNDx̕ύX}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



/** %jp{^XNDx̕ύX} */
ER chg_pri(ID tskid, PRI tskpri)
{
	_KERNEL_T_TSKHDL   tskhdl;
	_KERNEL_T_TCB_PTR  tcb;
	_KERNEL_TSK_T_TPRI tskpri_old;

	if ( tskid == TSK_SELF )		/* %jp{^XNw莞̕ϊ} */
	{
#if _KERNEL_SPT_REF_TSK_E_ID
		if ( _KERNEL_SYS_SNS_CTX() )
		{
			return E_ID;		/* %jp{sIDԍ} */
		}
#endif	
		
		/* %jp{s^XN擾} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();
		
		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{T[rXR[ɓ} */
		
		/* %jp{TCB擾} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	}
	else
	{
#if _KERNEL_SPT_REF_TSK_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;	/* %jp{sIDԍ} */
		}
#endif
		
		_KERNEL_ENTER_SVC();			/* %jp{enter service-call}%jp{T[rXR[ɓ} */
		
		/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_REF_TSK_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{T[rXR[o} */
			return E_NOEXS;				/* %jp{IuWFNg} */
		}
#endif
		/* IDԍw莞̕ϊ */
		tcb    = _KERNEL_TSK_ID2TCB(tskid);
		tskhdl = _KERNEL_TSK_GET_TSKHDL(tskid, tcb);
	}
	
	
	if ( tskpri == TPRI_INI )
	{
		_KERNEL_T_TCB_RO_PTR tcb_ro;
		tcb_ro = _KERNEL_TSK_GET_TCB_RO(tskid, tcb);
		tskpri = _KERNEL_TSK_GET_ITSKPRI(tcb_ro);
	}
	
	
	/* %jp{x[XDxύX} */
	_KERNEL_TSK_SET_TSKBPRI(tcb, tskpri);
	
	/* %jp{݂̃^XNDx擾} */
	tskpri_old = _KERNEL_TSK_GET_TSKPRI(tcb);
	
	/* %jp{Dxオ邩A~[ebNXsȂDxύX} */
	if ( tskpri < (PRI)tskpri_old || _KERNEL_TSK_GET_MTXHDL(tcb) == _KERNEL_MTXHDL_NULL )
	{
		_KERNEL_SYS_RMV_RDQ(tskhdl);
		_KERNEL_TSK_SET_TSKPRI(tcb, tskpri);
		_KERNEL_SYS_ADD_RDQ(tskhdl);
		
		/* %jp{^XNfBXpb`} */
		_KERNEL_DSP_STA_TSK(tskhdl);
	}
	
	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
	
	return E_OK;
}


/* end of file */
