/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ext_tsk.c
 * @brief %jp{^XN̏I}%en{Exit Task}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mtxobj.h"


/** %jp{^XN̏I}%en{Exit Task}
 * @return void
 */
void ext_tsk(void)
{
	_KERNEL_T_TSKHDL     tskhdl;
	_KERNEL_T_TCB        *tcb;
	_KERNEL_T_TCB_RO     *tcb_ro;
	_KERNEL_TSK_T_ACTCNT actcnt;

	/* %jp{s^XN擾} */
	tskhdl = _KERNEL_SYS_GET_RUNTSK();

	_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{T[rXR[ɓ} */
	
	/* %jp{fB[L[폜} */
	_KERNEL_DSP_EXT_TSK(tskhdl);

	/* %jp{TCB擾} */
	tcb    = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	tcb_ro = _KERNEL_TSK_GET_TCB_RO(_KERNEL_TSK_TSKHDL2ID(tskhdl), tcb);
	
	
	/* %jp{L~[ebNXΊJ} */
#if _KERNEL_SPT_MTX
	{
		_KERNEL_T_MTXHDL mtxhdl;
		while ( (mtxhdl = _KERNEL_TSK_GET_MTXHDL(tcb)) != _KERNEL_MTXHDL_NULL )
		{
			_kernel_rmv_mtx(mtxhdl, tskhdl);
		}
	}
#endif
	
	
	/* %jp{NvlXg̃`FbN} */
	actcnt = _KERNEL_TSK_GET_ACTCNT(tcb);
	if ( actcnt > 0 )	/* %jp{NvlXgȂĐ} */
	{
		_KERNEL_TSK_T_TPRI   itskpri;
		
		_KERNEL_TSK_SET_ACTCNT(tcb, actcnt - 1);
		itskpri = _KERNEL_TSK_GET_ITSKPRI(tcb_ro);
		_KERNEL_TSK_SET_TSKPRI(tcb, itskpri);
		_KERNEL_TSK_SET_TSKBPRI(tcb, itskpri);
		
		/* %jp{fB[L[Đڑ} */
		_KERNEL_DSP_STA_TSK(tskhdl);						
	}
	else				/* %jp{NvlXgȂΏI} */
	{
		_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_DMT);
	}
	
	/* %jp{^XNfBXpb`̎s}%en{task dispatch} */
	_KERNEL_DSP_TSK();
	
	/* %jp{X^[g} */
	_KERNEL_RST_CTX(
				_KERNEL_TSK_GET_CTXCB(tcb),					/* %jp{ReLXgubN} */
				_KERNEL_TSK_GET_STKSZ(tcb_ro),				/* %jp{^XÑX^bN̈TCY} */
				_KERNEL_TSK_GET_STK(tcb_ro),				/* %jp{^XÑX^bN̈̐擪Ԓn} */
				_KERNEL_TSK_GET_ISP(tcb_ro),				/* %jp{X^bN|C^̏l} */
				(FP)_kernel_ent_tsk,						/* %jp{ReLXg̊JnAhX} */
				(VP_INT)_KERNEL_TSK_GET_EXINF(tcb_ro),		/* %jp{^XN̊g} */
				(VP_INT)_KERNEL_TSK_GET_TASK(tcb_ro)		/* %jp{^XN̋NԒn} */
			);
}


/* end of file */
