/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  irel_wai.c
 * @brief %jp{҂Ԃ̋}%en{Release Task from Waiting}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



#if _KERNEL_SPT_IREL_WAI


#if _KERNEL_SPT_DPC

static void _kernel_dpc_rel_wai(ID tskid, VP_INT param);

/** %jp{҂Ԃ̋}%en{Release Task from Waiting}
 * @param  tskid    %jp{҂Ԃ̋Ώۂ̃^XNIDԍ}%en{ID number of the task to be release task from waiting}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(tskids邢͎gpłȂ)}%en{Invalid ID number(tskid is invalid or unusable)}
 * @retval E_NOMEM  %jp{s}%en{Insufficient memory}
 */
ER irel_wai(
		ID tskid)
{
	
	
#if _KERNEL_SPT_IREL_WAI_E_ID
	if ( tskid == TSK_SELF )		/* %jp{^XNw莞̕ϊ} */
	{
		return E_ID;			/* %jp{sIDԍ}%en{Invalid ID number} */
	}
	
	if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
	{
		return E_ID;			/* %jp{sIDԍ}%en{Invalid ID number} */
	}

#endif

	/* %jp{xsv} */
	return _KERNEL_SYS_REQ_DPC(_kernel_dpc_rel_wai, tskid, 0);
}


void _kernel_dpc_rel_wai(ID tskid, VP_INT param)
{
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;

	/* %jp{s^XN擾} */
	tskhdl = _KERNEL_SYS_GET_RUNTSK();
	
	/* %jp{TCB擾}%en{get TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{^XNԎ擾`FbN} */
#if _KERNEL_SPT_IREL_WAI_E_OBJ
	{
		_KERNEL_TSK_T_TSKSTAT tskstat;

		tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
		if ( !(tskstat & _KERNEL_TTS_WAI) )
		{
			return;			/* %jp{IuWFNgԃG[}%en{Object state error} */
		}
	}
#endif
	
	/* %jp{҂} */
	_KERNEL_TRM_QUE(tskhdl);
	_KERNEL_TSK_SET_ERCD(tcb, E_RLWAI);		/* %jp{G[R[hݒ} */
	_KERNEL_DSP_WUP_TSK(tskhdl);			/* %jp{^XN̑҂} */
}


#else	/* _KERNEL_SPT_DPC */


/** %jp{҂Ԃ̋}%en{Release Task from Waiting}
 * @param  tskid    %jp{҂Ԃ̋Ώۂ̃^XNIDԍ}%en{ID number of the task to be release task from waiting}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(tskids邢͎gpłȂ)}%en{Invalid ID number(tskid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(Ώۃ^XNo^)}%en{Non-existant object(specified task is not registered)}
 * @retval E_OBJ    %jp{IuWFNgԃG[(Ώۃ^XN҂ԂłȂ)}%en{Object state error(specified task is neither in WAITING state)}
 */
ER irel_wai(
		ID tskid)
{
	return rel_wai(tskid);
}

#endif	/* _KERNEL_SPT_DPC*/



#else	/* _KERNEL_SPT_IREL_WAI */


#if _KERNEL_SPT_REL_WAI_E_NOSPT

/** %jp{҂Ԃ̋}%en{Release Task from Waiting}
 * @param  tskid    %jp{҂Ԃ̋Ώۂ̃^XNIDԍ}%en{ID number of the task to be release task from waiting}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER irel_wai(
		ID tskid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_IREL_WAI */



/* end of file */
