/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  def_tex.c
 * @brief %en{Activate Task}%jp{^XN̋N}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


/* %jp{^XNO̎s} */
void _kernel_exe_tex(_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TCB_PTR		tcb;
	_KERNEL_T_TCB_RO_PTR	tcb_ro;
	_KERNEL_TSK_T_TEXPTN	rasptn;
	_KERNEL_TSK_T_TEXRTN	texrtn;
	_KERNEL_TSK_T_EXINF		exinf;
	
	
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{^XNO֎~Ȃ牽Ȃ} */
	if ( _KERNEL_TSK_GET_TEXSTAT(tcb) != _KERNEL_TXS_ENA )
	{
		return;
	}
	
	/* %jp{^XNOvȂΉȂ} */
	if ( (rasptn = _KERNEL_TSK_GET_RASPTN(tcb)) == 0 )
	{
		return;
	}
	
	tcb_ro = _KERNEL_TSK_GET_TCB_RO(_KERNEL_TSK_TSKHDL2ID(tskhdl_run), tcb);
	exinf  = _KERNEL_TSK_GET_EXINF(tcb_ro);
	
	/* %jp{OvȂ܂Ŏs} */
	do
	{
		_KERNEL_TSK_SET_TEXSTAT(tcb, _KERNEL_TXS_DIS);
		_KERNEL_TSK_SET_RASPTN(tcb, 0);
				
		texrtn = _KERNEL_TSK_GET_TEXRTN(tcb_ro);
				
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */

		/* %jp{^XNOĂяo} */
		texrtn((TEXPTN)rasptn, (VP_INT)exinf);

		_KERNEL_ENTER_SVC();	/* %jp{T[rXR[ɓ}%en{enter service-call} */
	} while ( (rasptn = _KERNEL_TSK_GET_RASPTN(tcb)) != 0 );

	_KERNEL_TSK_SET_TEXSTAT(tcb, _KERNEL_TXS_ENA);
}


/* end of file */
