/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  rsm_tsk.c
 * @brief %jp{҂Ԃ̍ĊJ}%en{Resume Suspended Task}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_RSM_TSK


/** %jp{҂Ԃ̍ĊJ}%en{Resume Suspended Task}
 * @param  tskid    %jp{ĊJΏۂ̃^XNIDԍ}%en{ID number of the task to be resumed}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(tskids邢͎gpłȂ)}%en{Invalid ID number(tskid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(Ώۃ^XNo^)}%en{Non-existant object(specified task is not registered)}
 * @retval E_OBJ    %jp{IuWFNgԃG[(Ώۃ^XN҂ԂłȂ)}%en{Object state error(specified task is neither in SUSPENDED state nor WAITING-SUSPENDED state)}
 */
ER rsm_tsk(
		ID tskid)
{
	_KERNEL_T_TSKHDL      tskhdl;
	_KERNEL_T_TCB         *tcb;
	_KERNEL_TSK_T_SUSCNT  suscnt;


#if _KERNEL_SPT_RSM_TSK_E_ID
	if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
	{
		return E_ID;				/* %jp{sIDԍ} */
	}
#endif
	
	_KERNEL_ENTER_SVC();			/* %jp{T[rXR[ɓ}%en{enter service-call} */
		
	/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_RSM_TSK_E_NOEXS
	if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOEXS;				/* %jp{IuWFNg}%en{Non-existant object} */
	}
#endif
	
	/* IDԍw莞̕ϊ */
	tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	
	/* %jp{Rg[ubN擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{^XNԃ`FbN}%en{check current state} */
#if _KERNEL_SPT_RSM_TSK_E_OBJ
	{
		_KERNEL_TSK_T_TSKSTAT tskstat;
		tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
		if ( !(tskstat & _KERNEL_TTS_SUS) )
		{
			_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
			return E_OBJ;			/* %jp{IuWFNgԃG[}%en{Object state error} */
		}
	}
#endif
	
	/* %jp{҂} */
	suscnt = _KERNEL_TSK_GET_SUSCNT(tcb);
	if ( suscnt > 0 )
	{
		/* %jp{TXyhJE^fNg} */
		_KERNEL_TSK_SET_SUSCNT(tcb, suscnt - 1);
	}
	else
	{
		_KERNEL_DSP_RSM_TSK(tskhdl);	/* %jp{^XN̋҂} */
		_KERNEL_DSP_TSK();
	}

	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_RSM_TSK */


#if _KERNEL_SPT_RSM_TSK_E_NOSPT


/** %jp{҂Ԃ̋ĊJ}%en{Forcibly Resume Suspended Task}
 * @param  tskid    %jp{ĊJΏۂ̃^XNIDԍ}%en{ID number of the task to be resumed}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER rsm_tsk(
		ID tskid)
{
	return E_NOSPT;
}

#endif


#endif


/* end of file */
