/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  sus_tsk.c
 * @brief 
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_SUS_TSK


ER sus_tsk(
		ID tskid)
{
	_KERNEL_T_TSKHDL      tskhdl;
	_KERNEL_T_TCB         *tcb;
	_KERNEL_TSK_T_TSKSTAT tskstat;

	
	/* %jp{^XNnh擾} */
	if ( tskid == TSK_SELF )		/* %jp{^XNw莞̕ϊ} */
	{
		/* %jp{s^XN擾} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();
		
		_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	}
	else
	{
#if _KERNEL_SPT_SUS_TSK_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;			/* %jp{sIDԍ} */
		}
#endif
	
		_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
		
		/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_SUS_TSK_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
			return E_NOEXS;			/* %jp{IuWFNg} */
		}
#endif
		/* IDԍw莞̕ϊ */
		tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	}
	
	
	/* %jp{ReLXg`FbN} */	
#if _KERNEL_SPT_SUS_TSK_E_CTX
		if ( _KERNEL_SYS_GET_RUNTSK() == tskhdl && _KERNEL_SYS_SNS_DPN() )
		{
			_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
			return E_CTX;			/* %jp{ReLXgs} */
		}
#endif
	
	/* %jp{Rg[ubN擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{^XNԎ擾} */
	tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
	
	
	/* %jp{ԃ`FbN} */	
#if _KERNEL_SPT_SUS_TSK_E_CTX
	if ( tskstat == _KERNEL_TTS_DMT )
	{
			_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
			return E_OBJ;			/* %jp{ԕs} */		
	}
#endif
	
	/* %jp{TXyh} */
	if ( tskstat & _KERNEL_TTS_SUS )
	{
		_KERNEL_TSK_T_SUSCNT suscnt;
		
		/* %jp{݂̃TXyhJE^擾} */
		suscnt = _KERNEL_TSK_GET_SUSCNT(tcb);
		
#if _KERNEL_SPT_SUS_TSK_E_QOVR
		if ( suscnt >= _KERNEL_TMAX_SUSCNT )
		{
			_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
			return E_QOVR;			/* %jp{L[COI[o[t[} */
		}
#endif

		_KERNEL_TSK_SET_SUSCNT(tcb, suscnt + 1);
	}
	else
	{
		_KERNEL_DSP_SUS_TSK(tskhdl);	/* %jp{^XN̋҂} */
		
		_KERNEL_DSP_TSK();
	}
	
	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */

	return E_OK;
}


#else	/* _KERNEL_SPT_SUS_TSK */


#if _KERNEL_SPT_SUS_TSK_E_NOSPT

ER sus_tsk(
		ID tskid)
{
	return E_NOSPT;
}

#endif


#endif


/* end of file */
