
				EXPORT	Reset_Handler
				EXPORT	Undefined_Handler
				EXPORT	Swi_Handler
				EXPORT	Prefetch_Handler
				EXPORT	Abort_Handler
				IMPORT	_kernel_int_isp



; %jp{vZbT[h`}
Mode_USR		EQU 	0x10		; USR [h
Mode_FIQ		EQU		0x11		; FIQ [h
Mode_IRQ		EQU 	0x12		; IRQ [h
Mode_SVC		EQU		0x13		; SVC [h
Mode_ABT		EQU		0x17		; ABT [h
Mode_UND		EQU		0x1b		; UND [h
Mode_SYS		EQU 	0x1f		; SYS [h
Mode_MASK		EQU 	0x1f		; [hrbg}XN

; %jp{tO`}
T_Bit			EQU		0x20		; T rbg
F_Bit			EQU 	0x40		; F rbg
I_Bit			EQU 	0x80		; I rbg



				CODE32

				PRESERVE8
				AREA	Init, CODE, READONLY


; Zbgnh
Reset_Handler
		; --- SYS[hڍs
				msr		cpsr_c, #Mode_SYS:OR:F_Bit:OR:I_Bit

		; --- X^bNݒ
				ldr		r0, =_kernel_int_isp
				ldr 	sp, [r0]
				
		; --- CR[hɃWv
				IMPORT	__main
				bl		__main
end_loop
				b		end_loop




;  SWInh
Swi_Handler
				movs	pc, lr


;  Undefined nh
Undefined_Handler
				b		Undefined_Handler


;  Prefetch nh
Prefetch_Handler
				b		Prefetch_Handler


;  Abort nh
Abort_Handler
				b		Abort_Handler



				END


; end of file                                            
