/* SH7144 WX^`t@C */



#ifndef __sh7144_regs_h__
#define __sh7144_regs_h__


/* SCI0 */
#define	REG_SCI0_SMR		((volatile UB*)0xffff81a0)		/* VA[hWX^_0 */
#define	REG_SCI0_BRR		((volatile UB*)0xffff81a1)		/* rbg[gWX^_0 */
#define	REG_SCI0_SCR		((volatile UB*)0xffff81a2)		/* VARg[WX^_0 */
#define	REG_SCI0_TDR		((volatile UB*)0xffff81a3)		/* gX~bgf[^WX^_0 */
#define	REG_SCI0_SSR		((volatile UB*)0xffff81a4)		/* VAXe[^XWX^_0 */
#define	REG_SCI0_RDR		((volatile UB*)0xffff81a5)		/* V[uf[^WX^_0 */
#define	REG_SCI0_SDCR		((volatile UB*)0xffff81a6)		/* VAfBNVRg[WX^_0 */

/* SCI1 */
#define	REG_SCI1_SMR		((volatile UB*)0xffff81b0)		/* VA[hWX^_1 */
#define	REG_SCI1_BRR		((volatile UB*)0xffff81b1)		/* rbg[gWX^_1 */
#define	REG_SCI1_SCR		((volatile UB*)0xffff81b2)		/* VARg[WX^_1 */
#define	REG_SCI1_TDR		((volatile UB*)0xffff81b3)		/* gX~bgf[^WX^_1 */
#define	REG_SCI1_SSR		((volatile UB*)0xffff81b4)		/* VAXe[^XWX^_1 */
#define	REG_SCI1_RDR		((volatile UB*)0xffff81b5)		/* V[uf[^WX^_1 */
#define	REG_SCI1_SDCR		((volatile UB*)0xffff81b6)		/* VAfBNVRg[WX^_1 */

/* SCI2 */
#define	REG_SCI2_SMR		((volatile UB*)0xffff81c0)		/* VA[hWX^_2 */
#define	REG_SCI2_BRR		((volatile UB*)0xffff81c1)		/* rbg[gWX^_2 */
#define	REG_SCI2_SCR		((volatile UB*)0xffff81c2)		/* VARg[WX^_2 */
#define	REG_SCI2_TDR		((volatile UB*)0xffff81c3)		/* gX~bgf[^WX^_2 */
#define	REG_SCI2_SSR		((volatile UB*)0xffff81c4)		/* VAXe[^XWX^_2 */
#define	REG_SCI2_RDR		((volatile UB*)0xffff81c5)		/* V[uf[^WX^_2 */
#define	REG_SCI2_SDCR		((volatile UB*)0xffff81c6)		/* VAfBNVRg[WX^_2 */

/* SCI3 */
#define	REG_SCI3_SMR		((volatile UB*)0xffff81d0)		/* VA[hWX^_3 */
#define	REG_SCI3_BRR		((volatile UB*)0xffff81d1)		/* rbg[gWX^_3 */
#define	REG_SCI3_SCR		((volatile UB*)0xffff81d2)		/* VARg[WX^_3 */
#define	REG_SCI3_TDR		((volatile UB*)0xffff81d3)		/* gX~bgf[^WX^_3 */
#define	REG_SCI3_SSR		((volatile UB*)0xffff81d4)		/* VAXe[^XWX^_3 */
#define	REG_SCI3_RDR		((volatile UB*)0xffff81d5)		/* V[uf[^WX^_3 */
#define	REG_SCI3_SDCR		((volatile UB*)0xffff81d6)		/* VAfBNVRg[WX^_3 */

/* MTU 3,4 */
#define	REG_MTU3_TCR		((volatile UB*)0xffff8200)		/* ^C}Rg[WX^_3 */
#define	REG_MTU4_TCR		((volatile UB*)0xffff8201)		/* ^C}Rg[WX^_4 */
#define	REG_MTU3_TMDR		((volatile UB*)0xffff8202)		/* ^C}[hWX^_3 */
#define	REG_MTU4_TMDR		((volatile UB*)0xffff8203)		/* ^C}[hWX^_4 */
#define	REG_MTU3_TIORH	 	((volatile UB*)0xffff8204)		/* ^C}I/O Rg[WX^H_3 */
#define	REG_MTU3_TIORL	 	((volatile UB*)0xffff8205)		/* ^C}I/O Rg[WX^L_3 */
#define	REG_MTU4_TIORH	 	((volatile UB*)0xffff8206)		/* ^C}I/O Rg[WX^H_4 */
#define	REG_MTU4_TIORL	 	((volatile UB*)0xffff8207)		/* ^C}I/O Rg[WX^L_4 */
#define	REG_MTU3_TIER		((volatile UB*)0xffff8208)		/* ^C}C^vgCl[uWX^_3 */
#define	REG_MTU4_TIER		((volatile UB*)0xffff8209)		/* ^C}C^vgCl[uWX^_4 */
#define	REG_MTU_TOER		((volatile UB*)0xffff820a)		/* ^C}AEgvbg}X^Cl[uWX^ */
#define	REG_MTU_TOCR		((volatile UB*)0xffff820b)		/* ^C}AEgvbgRg[WX^ */
#define	REG_MTU_TGCR		((volatile UB*)0xffff820d)		/* ^C}Q[gRg[WX^ */
#define	REG_MTU3_TCNT		((volatile UH*)0xffff8210)		/* ^C}JE^_3 */
#define	REG_MTU4_TCNT		((volatile UH*)0xffff8212)		/* ^C}JE^_4 */
#define	REG_MTU_TCDR		((volatile UH*)0xffff8214)		/* ^C}f[^WX^ */
#define	REG_MTU_TDDR		((volatile UH*)0xffff8216)		/* ^C}fbh^Cf[^WX^ */
#define	REG_MTU3_TGRA		((volatile UH*)0xffff8218)		/* ^C}WFlWX^A_3 */
#define	REG_MTU3_TGRB		((volatile UH*)0xffff821a)		/* ^C}WFlWX^B_3 */
#define	REG_MTU4_TGRA		((volatile UH*)0xffff821c)		/* ^C}WFlWX^A_4 */
#define	REG_MTU4_TGRB		((volatile UH*)0xffff821e)		/* ^C}WFlWX^B_4 */
#define	REG_MTU_TCNTS		((volatile UH*)0xffff8220)		/* ^C}TuJE^ */
#define	REG_MTU_TCBR		((volatile UH*)0xffff8222)		/* ^C}obt@WX^ */
#define	REG_MTU3_TGRC		((volatile UH*)0xffff8224)		/* ^C}WFlWX^C_3 */
#define	REG_MTU3_TGRD		((volatile UH*)0xffff8226)		/* ^C}WFlWX^D_3 */
#define	REG_MTU4_TGRC		((volatile UH*)0xffff8228)		/* ^C}WFlWX^C_4 */
#define	REG_MTU4_TGRD		((volatile UH*)0xffff822a)		/* ^C}WFlWX^D_4 */
#define	REG_MTU3_TSR		((volatile UB*)0xffff822c)		/* ^C}Xe[^XWX^_3 */
#define	REG_MTU4_TSR		((volatile UB*)0xffff822d)		/* ^C}Xe[^XWX^_4 */

/* MTU(common) */
#define	REG_MTU_TSTR		((volatile UB*)0xffff8240)		/* ^C}X^[gWX^ */
#define	REG_MTU_TSYR		((volatile UB*)0xffff8241)		/* ^C}VNWX^ */

/* MTU0 */
#define	REG_MTU0_TCR		((volatile UB*)0xffff8260)		/* ^C}Rg[WX^_0 */
#define	REG_MTU0_TMDR		((volatile UB*)0xffff8261)		/* ^C}[hWX^_0 */
#define	REG_MTU0_TIORH	 	((volatile UB*)0xffff8262)		/* ^C}I/ORg[WX^H_0 */
#define	REG_MTU0_TIORL	 	((volatile UB*)0xffff8263)		/* ^C}I/ORg[WX^L_0 */
#define	REG_MTU0_TIER		((volatile UB*)0xffff8264)		/* ^C}C^vgCl[uWX^_0 */
#define	REG_MTU0_TSR		((volatile UB*)0xffff8265)		/* ^C}Xe[^XWX^_0 */
#define	REG_MTU0_TCNT		((volatile UH*)0xffff8266)		/* ^C}JE^_0 */
#define	REG_MTU0_TGRA		((volatile UH*)0xffff8268)		/* ^C}WFlWX^A_0 */
#define	REG_MTU0_TGRB		((volatile UH*)0xffff826a)		/* ^C}WFlWX^B_0 */
#define	REG_MTU0_TGRC		((volatile UH*)0xffff826c)		/* ^C}WFlWX^C_0 */
#define	REG_MTU0_TGRD		((volatile UH*)0xffff826e)		/* ^C}WFlWX^D_0 */

/* MTU1 */
#define	REG_MTU1_TCR		((volatile UB*)0xffff8280)		/* ^C}Rg[WX^_1 */
#define	REG_MTU1_TMDR		((volatile UB*)0xffff8281)		/* ^C}[hWX^_1 */
#define	REG_MTU1_TIOR		((volatile UB*)0xffff8282)		/* ^C}I/ORg[WX^_1 */
#define	REG_MTU1_TIER		((volatile UB*)0xffff8284)		/* ^C}C^vgCl[uWX^_1 */
#define	REG_MTU1_TSR		((volatile UB*)0xffff8285)		/* ^C}Xe[^XWX^_1 */
#define	REG_MTU1_TCNT		((volatile UH*)0xffff8286)		/* ^C}JE^_1 */
#define	REG_MTU1_TGRA		((volatile UH*)0xffff8288)		/* ^C}WFlWX^A_1 */
#define	REG_MTU1_TGRB		((volatile UH*)0xffff828a)		/* ^C}WFlWX^B_1 */

/* MTU2 */
#define	REG_MTU2_TCR		((volatile UB*)0xffff82a0)		/* ^C}Rg[WX^_2 */
#define	REG_MTU2_TMDR		((volatile UB*)0xffff82a1)		/* ^C}[hWX^_2 */
#define	REG_MTU2_TIOR		((volatile UB*)0xffff82a2)		/* ^C}I/O Rg[WX^_2 */
#define	REG_MTU2_TIER		((volatile UB*)0xffff82a4)		/* ^C}C^vgCl[uWX^_2 */
#define	REG_MTU2_TSR		((volatile UB*)0xffff82a5)		/* ^C}Xe[^XWX^_2 */
#define	REG_MTU2_TCNT		((volatile UH*)0xffff82a6)		/* ^C}JE^_2 */
#define	REG_MTU2_TGRA		((volatile UH*)0xffff82a8)		/* ^C}WFlWX^A_2 */
#define	REG_MTU2_TGRB		((volatile UH*)0xffff82aa)		/* ^C}WFlWX^B_2 */

/* INTC */
#define	REG_INTC_IPRA		((volatile UH*)0xffff8348)		/* C^vgvCIeBWX^A */
#define	REG_INTC_IPRB		((volatile UH*)0xffff834a)		/* C^vgvCIeBWX^B */
#define	REG_INTC_IPRC		((volatile UH*)0xffff834c)		/* C^vgvCIeBWX^C */
#define	REG_INTC_IPRD		((volatile UH*)0xffff834e)		/* C^vgvCIeBWX^D */
#define	REG_INTC_IPRE		((volatile UH*)0xffff8350)		/* C^vgvCIeBWX^E */
#define	REG_INTC_IPRF		((volatile UH*)0xffff8352)		/* C^vgvCIeBWX^F */
#define	REG_INTC_IPRG		((volatile UH*)0xffff8354)		/* C^vgvCIeBWX^G */
#define	REG_INTC_IPRH		((volatile UH*)0xffff8356)		/* C^vgvCIeBWX^H */
#define	REG_INTC_ICR1		((volatile UH*)0xffff8358)		/* ݃Rg[WX^1 */
#define	REG_INTC_ISR 		((volatile UH*)0xffff835a)		/* IRQXe[^XWX^ */
#define	REG_INTC_IPRI		((volatile UH*)0xffff835c)		/* C^vgvCIeBWX^I */
#define	REG_INTC_IPRJ		((volatile UH*)0xffff835e)		/* C^vgvCIeBWX^J */
#define	REG_INTC_ICR2		((volatile UH*)0xffff8366)		/* ݃Rg[WX^2 */

/* I/O, PFC (port-A) */
#define	REG_PA_DR			((volatile UW*)0xffff8380)		/* |[gA f[^WX^(H/L) */
#define	REG_PA_DRH			((volatile UH*)0xffff8380)		/* |[gA f[^WX^H */
#define	REG_PA_DRL			((volatile UH*)0xffff8382)		/* |[gA f[^WX^L */
#define	REG_PFC_PAIORH		((volatile UH*)0xffff8384)		/* |[gA IOWX^H */
#define	REG_PFC_PAIORL		((volatile UH*)0xffff8386)		/* |[gA IOWX^L */
#define	REG_PFC_PACRH		((volatile UH*)0xffff8388)		/* |[gARg[WX^H */
#define	REG_PFC_PACRL1		((volatile UH*)0xffff838c)		/* |[gARg[WX^L1 */
#define	REG_PFC_PACRL2		((volatile UH*)0xffff838e)		/* |[gARg[WX^L2 */

/* I/O, PFC (port-B, C) */
#define	REG_PB_DR			((volatile UH*)0xffff8390)		/* |[gB f[^WX^ */
#define	REG_PC_DR			((volatile UH*)0xffff8392)		/* |[gC f[^WX^ */
#define	REG_PFC_PBIOR		((volatile UH*)0xffff8394)		/* |[gB IOWX^ */
#define	REG_PFC_PCIOR		((volatile UH*)0xffff8396)		/* |[gC IOWX^ */
#define	REG_PFC_PBCR1		((volatile UH*)0xffff8398)		/* |[gBRg[WX^1 */
#define	REG_PFC_PBCR2		((volatile UH*)0xffff839a)		/* |[gBRg[WX^2 */
#define	REG_PFC_PCCR		((volatile UH*)0xffff839c)		/* |[gCRg[WX^2 */

/* I/O, PFC (port-D) */
#define	REG_PD_DR			((volatile UW*)0xffff83a0)		/* |[gDEf[^WX^(H/L) */
#define	REG_PD_DRH			((volatile UH*)0xffff83a0)		/* |[gDEf[^WX^H */
#define	REG_PD_DRL			((volatile UH*)0xffff83a2)		/* |[gDEf[^WX^L */
#define	REG_PFC_PDIORH		((volatile UH*)0xffff83a4)		/* |[gDEIOWX^H */
#define	REG_PFC_PDIORL		((volatile UH*)0xffff83a6)		/* |[gDEIOWX^L */
#define	REG_PFC_PDCRH1		((volatile UH*)0xffff83a8)		/* |[gDRg[WX^H1 */
#define	REG_PFC_PDCRH2		((volatile UH*)0xffff83aa)		/* |[gDRg[WX^H2 */
#define	REG_PFC_PDCRL1		((volatile UH*)0xffff83ac)		/* |[gDRg[WX^L1 */
#define	REG_PFC_PDCRL2		((volatile UH*)0xffff83ae)		/* |[gDRg[WX^L2 */

/* I/O, PFC (port-E, F) */
#define	REG_PE_DRL			((volatile UH*)0xffff83b0)		/* |[gE f[^WX^L */
#define	REG_PF_DR			((volatile UB*)0xffff83b3)		/* |[gF f[^WX^ */
#define	REG_PFC_PEIORL		((volatile UH*)0xffff83b4)		/* |[gE IO WX^L */
#define	REG_PFC_PECRL1		((volatile UH*)0xffff83b8)		/* |[gE Rg[WX^L1 */
#define	REG_PFC_PECRL2		((volatile UH*)0xffff83ba)		/* |[gE Rg[WX^L2 */

/* POE */
#define	REG_POE_ICSR1		((volatile UH*)0xffff83c0)		/* ̓xRg[^Xe[^XWX^1 */
#define	REG_POE_OCSR		((volatile UH*)0xffff83c2)		/* o̓xRg[^Xe[^XWX^ */

/* CMT */
#define	REG_CMT_CMSTR		((volatile UH*)0xffff83d0)		/* RyA}b`^C}X^[gWX^ */
#define	REG_CMT0_CMCSR 		((volatile UH*)0xffff83d2)		/* RyA}b`^C}Rg[^Xe[^XWX^_0 */
#define	REG_CMT0_CMCNT 		((volatile UH*)0xffff83d4)		/* RyA}b`^C}JE^_0 */
#define	REG_CMT0_CMCOR 		((volatile UH*)0xffff83d6)		/* RyA}b`^C}RX^gWX^_0 */
#define	REG_CMT1_CMCSR 		((volatile UH*)0xffff83d8)		/* RyA}b`^C}Rg[^Xe[^XWX^_1 */
#define	REG_CMT1_CMCNT 		((volatile UH*)0xffff83da)		/* RyA}b`^C}JE^_1 */
#define	REG_CMT1_CMCOR 		((volatile UH*)0xffff83dc)		/* RyA}b`^C}RX^gWX^_1 */

/* AD */
#define	REG_AD0_ADDR0		((volatile UH*)0xffff8420)		/* A/Df[^WX^0 */
#define	REG_AD0_ADDR1		((volatile UH*)0xffff8422)		/* A/Df[^WX^1 */
#define	REG_AD0_ADDR2		((volatile UH*)0xffff8424)		/* A/Df[^WX^2 */
#define	REG_AD0_ADDR3		((volatile UH*)0xffff8426)		/* A/Df[^WX^3 */
#define	REG_AD1_ADDR4		((volatile UH*)0xffff8428)		/* A/Df[^WX^4 */
#define	REG_AD1_ADDR5		((volatile UH*)0xffff842a)		/* A/Df[^WX^5 */
#define	REG_AD1_ADDR6		((volatile UH*)0xffff842c)		/* A/Df[^WX^6 */
#define	REG_AD1_ADDR7		((volatile UH*)0xffff842e)		/* A/Df[^WX^7 */
#define	REG_AD0_ADCSR	 	((volatile UB*)0xffff8480)		/* A/DRg[^Xe[^XWX^_0 */
#define	REG_AD1_ADCSR	 	((volatile UB*)0xffff8481)		/* A/DRg[^Xe[^XWX^_1 */
#define	REG_AD0_ADCR		((volatile UB*)0xffff8488)		/* A/DRg[WX^_0 */
#define	REG_AD1_ADCR		((volatile UB*)0xffff8489)		/* A/DRg[WX^_1 */

/* FLASH */
#define	REG_FLASH_FLMCR1	((volatile UB*)0xffff8580)		/* tbVRg[WX^1 */
#define	REG_FLASH_FLMCR2	((volatile UB*)0xffff8581)		/* tbVRg[WX^2 */
#define	REG_FLASH_EBR1		((volatile UB*)0xffff8582)		/* ubNw背WX^1 */
#define	REG_FLASH_EBR2		((volatile UB*)0xffff8583)		/* ubNw背WX^2 */

/* UBC */
#define	REG_UBC_UBARH		((volatile UH*)0xffff8600)		/* [Uu[NAhXWX^H */
#define	REG_UBC_UBARL		((volatile UH*)0xffff8602)		/* [Uu[NAhXWX^L */
#define	REG_UBC_UBAMRH		((volatile UH*)0xffff8604)		/* [Uu[NAhX}XNWX^H */
#define	REG_UBC_UBAMRL		((volatile UH*)0xffff8606)		/* [Uu[NAhX}XNWX^L */
#define	REG_UBC_UBBR		((volatile UH*)0xffff8608)		/* [Uu[NoXTCNWX^ */
#define	REG_UBC_UBCR		((volatile UH*)0xffff860a)		/* [Uu[NRg[WX^ */

/* WDT */
#define	REG_WDT_TCSR		((volatile UB*)0xffff8610)		/* ^C}Rg[^Xe[^XWX^ */
#define	REG_WDT_TCNT_W		((volatile UB*)0xffff8610)		/* ^C}JE^(Read) */
#define	REG_WDT_TCNT_R		((volatile UB*)0xffff8611)		/* ^C}JE^(Write) */
#define	REG_WDT_RSTCSR_1	((volatile UB*)0xffff8612)		/* ZbgRg[^Xe[^XWX^ */
#define	REG_WDT_RSTCSR_2	((volatile UB*)0xffff8613)		/* ZbgRg[^Xe[^XWX^ */

/* Standby*/
#define	REG_STANDBY_SBYCR	((volatile UB*)0xffff8614)		/* X^oCRg[WX^ */
#define	REG_STANDBY_SYSCR	((volatile UB*)0xffff8618)		/* VXeRg[WX^ */
#define	REG_STANDBY_MSTCR1	((volatile UH*)0xffff861c)		/* W[X^oCRg[WX^1 */
#define	REG_STANDBY_MSTCR2	((volatile UH*)0xffff861e)		/* W[X^oCRg[WX^2 */

/* BSC */
#define	REG_BSC_BCR1		((volatile UH*)0xffff8620)		/* oXRg[WX^1 */
#define	REG_BSC_BCR2		((volatile UH*)0xffff8622)		/* oXRg[WX^2 */
#define	REG_BSC_WCR1		((volatile UH*)0xffff8624)		/* EFCgRg[WX^1 */
#define	REG_BSC_WCR2		((volatile UH*)0xffff8626)		/* EFCgRg[WX^2 */

/* FLASH */
#define	REG_FLASH_RAMER		((volatile UH*)0xffff8628)		/* RAMG~[VWX^ */

/* DMA */
#define	REG_DMA_DMAOR		((volatile UH*)0xffff86b0)		/* DMAIy[VWX^ */
#define	REG_DMA0_SAR		((volatile UW*)0xffff86c0)		/* DMA\[XAhXWX^_0 */
#define	REG_DMA0_DAR		((volatile UW*)0xffff86c4)		/* DMAfXeBl[VAhXWX^_0 */
#define	REG_DMA0_DMATCR		((volatile UW*)0xffff86c8)		/* DMAgXt@JEgWX^_0 */
#define	REG_DMA0_CHCR		((volatile UW*)0xffff86cc)		/* DMA`lRg[WX^_0 */
#define	REG_DMA1_SAR		((volatile UW*)0xffff86d0)		/* DMA\[XAhXWX^_1 */
#define	REG_DMA1_DAR		((volatile UW*)0xffff86d4)		/* DMAfXeBl[VAhXWX^_1 */
#define	REG_DMA1_DMATCR		((volatile UW*)0xffff86d8)		/* DMAgXt@JEgWX^_1 */
#define	REG_DMA1_CHCR		((volatile UW*)0xffff86dc)		/* DMA`lRg[WX^_1 */
#define	REG_DMA2_SAR		((volatile UW*)0xffff86e0)		/* DMA\[XAhXWX^_2 */
#define	REG_DMA2_DAR		((volatile UW*)0xffff86e4)		/* DMAfXeBl[VAhXWX^_2 */
#define	REG_DMA2_DMATCR		((volatile UW*)0xffff86e8)		/* DMAgXt@JEgWX^_2 */
#define	REG_DMA2_CHCR		((volatile UW*)0xffff86ec)		/* DMA`lRg[WX^_2 */
#define	REG_DMA3_SAR		((volatile UW*)0xffff86f0)		/* DMA\[XAhXWX^_3 */
#define	REG_DMA3_DAR		((volatile UW*)0xffff86f4)		/* DMAfXeBl[VAhXWX^_3 */
#define	REG_DMA3_DMATCR		((volatile UW*)0xffff86f8)		/* DMAgXt@JEgWX^_3 */
#define	REG_DMA3_CHCR		((volatile UW*)0xffff86fc)		/* DMA`lRg[WX^_3 */

/* DTC */
#define	REG_DTC_DTEA		((volatile UB*)0xffff8700)		/* DTCCl[uWX^A */
#define	REG_DTC_DTEB		((volatile UB*)0xffff8701)		/* DTCCl[uWX^B */
#define	REG_DTC_DTEC		((volatile UB*)0xffff8702)		/* DTCCl[uWX^C */
#define	REG_DTC_DTED		((volatile UB*)0xffff8703)		/* DTCCl[uWX^D */
#define	REG_DTC_DTCSR		((volatile UH*)0xffff8706)		/* DTCRg[^Xe[^XWX^ */
#define	REG_DTC_DTBR		((volatile UH*)0xffff8708)		/* DTCx[XWX^ */
#define	REG_DTC_DTEE		((volatile UB*)0xffff8710)		/* DTCCl[uWX^E */
#define	REG_DTC_DTEG		((volatile UB*)0xffff8712)		/* DTCCl[uWX^G */

/* IIC */
#define	REG_IIC_SCRX		((volatile UB*)0xffff87f0)		/* VARg[WX^X */

/* AD */
#define	REG_AD_ADTSR		((volatile UB*)0xffff87f4)		/* ADgKZNgWX^ */

/* Port-E */
#define	REG_PE_PPCR			((volatile UB*)0xffff87f8)		/* d|[gRg[WX^ */

/* IIC */
#define	REG_IIC_ICCR		((volatile UB*)0xffff87f8)		/* IICoXRg[WX^ */
#define	REG_IIC_ICSR		((volatile UB*)0xffff87f8)		/* IICoXXe[^XWX^ */
#define	REG_IIC_ICDR		((volatile UB*)0xffff87f8)		/* IICoXf[^WX^ */
#define	REG_IIC_SARX		((volatile UB*)0xffff87f8)		/* QX[uAhXWX^ */
#define	REG_IIC_ICMR		((volatile UB*)0xffff87f8)		/* IICoX[hWX^ */
#define	REG_IIC_SAR 		((volatile UB*)0xffff87f8)		/* X[uAhXWX^ */

/* H-UDI */
#define	REG_HUDI_SDIR		((volatile UH*)0xffff8a50)		/* CXgNVWX^ */
#define	REG_HUDI_SDSR		((volatile UH*)0xffff8a52)		/* Xe[^XWX^ */
#define	REG_HUDI_SDDRH		((volatile UH*)0xffff8a54)		/* f[^WX^H */
#define	REG_HUDI_SDDRL		((volatile UH*)0xffff8a56)		/* f[^WX^L */


#endif	/* __sh7144_regs_h__ */


/* end of file */
