/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  wintimer.c
 * @brief %jp{Windowsp̃^C}}%en{Windows timer object}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


/** %jp{Windows wb_t@C̓ǂ݂} */
#define SIZE  WIN_SIZE
#include <windows.h>
#undef  SIZE

#include "kernel.h"
#include "wintimer.h"
#include "arch/proc/win/win32/proc.h"


static DWORD WINAPI WinTimer_Thread(LPVOID param);		/**< %jp{^C}ݗpXbh֐} */
static HANDLE hEventTimer;								/**< %jp{^C}nh} */


/** %jp{OSp^C}̏} */
void WinTimer_Start(INHNO inhno, int iInterval)
{
	DWORD dwThreadId;
		
	/* %jp{^C}pCxg̍쐬} */
	hEventTimer = CreateEvent(NULL, FALSE, FALSE, NULL);
	
	/* %jp{}`fBA^C}̊Jn} */
	timeSetEvent(iInterval, 1, (LPTIMECALLBACK)hEventTimer, 0, TIME_PERIODIC | TIME_CALLBACK_EVENT_PULSE);
	
	/* %jp{Xbh} */
	CreateThread(NULL, 0, WinTimer_Thread, (LPVOID)inhno, 0, &dwThreadId);
}


/** %jp{^C}ݗpXbh֐} */
DWORD WINAPI WinTimer_Thread(LPVOID param)
{
	INHNO inhno;
	
	inhno = (INHNO)param;

	for ( ; ; )
	{
		/* %jp{^C}Cxg҂} */
		WaitForSingleObject(hEventTimer, INFINITE);

		/* %jp{݃VOi} */
		vsig_int(inhno);
	}
}


/* end of file */
