<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------+
// | PHP Version 5                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 2010 Takahiro Ooishi                                   |
// +----------------------------------------------------------------------+
// | This source file is subject to version 3.0 of the PHP license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available through the world-wide-web at the following url:           |
// | http://www.php.net/license/3_0.txt.                                  |
// | If you did not receive a copy of the PHP license and are unable to   |
// | obtain it through the world-wide-web, please send a note to          |
// | license@php.net so we can mail you a copy immediately.               |
// +----------------------------------------------------------------------+
// | Author: Takahiro Ooishi <taka0125.biz@gmail.com>                     |
// +----------------------------------------------------------------------+
//
// $Id$

class Http_Error
{
    protected $errorFlg;
    protected $faultString;

    function __construct()
    {
        $this->errorFlg = false;
        $this->faultString = '';
    }

    function isError()
    {
        return $this->errorFlg;
    }

    function get()
    {
        if (!$this->errorFlg) return '';
        return "faultString={$this->faultString}";
    }

    function set($fault_string)
    {
        $this->errorFlg = true;
        $this->faultString = $fault_string;
    }

    function clear()
    {
        $this->errorFlg = false;
        $this->faultString = '';
    }
}
