<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------+
// | PHP Version 5                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 2010 Takahiro Ooishi                                   |
// +----------------------------------------------------------------------+
// | This source file is subject to version 3.0 of the PHP license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available through the world-wide-web at the following url:           |
// | http://www.php.net/license/3_0.txt.                                  |
// | If you did not receive a copy of the PHP license and are unable to   |
// | obtain it through the world-wide-web, please send a note to          |
// | license@php.net so we can mail you a copy immediately.               |
// +----------------------------------------------------------------------+
// | Author: Takahiro Ooishi <taka0125.biz@gmail.com>                     |
// +----------------------------------------------------------------------+
//
// $Id$

class Http_Request
{
    protected $getParams;
    protected $postParams;
    protected $cookieFile;

    function __construct($get_params = array(), $post_params = array(), $cookie_file = null)
    {
        $this->setGetParams($get_params);
        $this->setPostParams($post_params);
        $this->setCookieFile($cookie_file);
    }

    function __destruct()
    {
        @unlink($this->cookieFile);
    }

    function getParams()
    {
        return $this->getParams;
    }

    function postParams()
    {
        return $this->postParams;
    }

    function cookieFile()
    {
        return $this->cookieFile;
    }

    function buildUrl($url)
    {
        if (!$this->existsGetParams()) return $url;

        $query_string = http_build_query($this->getParams);
        $items = parse_url($url);

        if ($this->existsQueryStrings($items)) {
            $query_string = "?{$items['query']}&{$query_string}";
        } else {
            $query_string = "?{$query_string}";
        }

        return "{$items['scheme']}://{$items['host']}{$items['path']}{$query_string}";
    }

    function isUseCookie()
    {
        if (!is_string($this->cookieFile)) return false;
        if (strlen($this->cookieFile) < 1) return false;
        return true;
    }

    function existsGetParams()
    {
        return $this->existsParams($this->getParams);
    }

    function existsPostParams()
    {
        return $this->existsParams($this->postParams);
    }

    protected function existsParams($params)
    {
        if (!is_array($params)) return false;
        if (count($params) < 1) return false;
        return true;
    }

    protected function existsQueryStrings($items)
    {
        if (!isset($items['query'])) return false;
        if (strlen($items['query']) < 1) return false;
        return true;
    }

    protected function setGetParams($params)
    {
        if ($this->isInvalidParams($params)) throw new ValidationException($params, 'Invalid GetParams.');
        $this->getParams = $params;
    }

    protected function setPostParams($params)
    {
        if ($this->isInvalidParams($params)) throw new ValidationException($params, 'Invalid PostParams.');
        $this->postParams = $params;
    }

    protected function setCookieFile($cookie_file)
    {
        if ($this->isInvalidCookieFile($cookie_file)) throw new ValidationException($cookie_file, 'Invalid CookieFile.');
        $this->cookieFile = $cookie_file;
    }

    protected function isInvalidParams($params)
    {
        if (!is_array($params)) return true;
        return false;
    }

    protected function isInvalidCookieFile($cookie_file)
    {
        if (is_null($cookie_file)) return false;
        if (!is_string($cookie_file)) return true;
        if (strlen($cookie_file) < 1) return true;
        return false;
    }
}
