#ifndef BUTTON_COMPONENT_H
#define BUTTON_COMPONENT_H

/*!
  \file
  \brief {^R|[lg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ComponentInterface.h"
#include <memory>

namespace beego {
  class TtfResource;
  class TextProperty;

  class ButtonComponent : public ComponentInterface {
    ButtonComponent(const ButtonComponent& rhs);
    ButtonComponent& operator = (const ButtonComponent& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      NoSelect = -1,
    };
    ButtonComponent(void);
    ~ButtonComponent(void);

    void addSurfaceList(SurfaceList& surfaces, const SDL_Rect* area,
                        size_t ticks);
    void setPosition(const SDL_Rect* position);
    void getPosition(SDL_Rect* position);
    size_t getWidth(void);
    size_t getHeight(void);
    void applyInput(const InputEvent& event,
                    std::vector<SDL_Rect>& applied_rects);
    void registerLayer(Layer* layer);

    // !!! 傫̈ႤT[tFXo^ꍇɂ́Aǂ̂ȁH
    // !!! - 傫͓ɂ
    // !!! - őTCYw肵ĂAT[tFXƈʒuwł悤ɂ
    // !!! - قȂT[tFXłAȂƌȂ
    // !!!   - T[tFX̊ʒuw肷
    // !!!     - SAAEA㉺AE

    // !!! `T[tFXTCYƁA̔zuItZbgw\ɂ

    // T[tFXo^
    void registerNormalSurface(Surface surface,
                               int x_offset =0, int y_offset = 0);

    // T[tFXo^
    void registerPressedSurface(Surface surface,
                                int x_offset =0, int y_offset = 0);

    // tH[JXT[tFXo^
    void registerFocusedSurface(Surface surface,
                                int x_offset =0, int y_offset = 0);

    Surface getNormalSurface(void);

    void showNormalSurface(void);
    void showPressedSurface(void);
    void showFocusedSurface(void);

    // !!! \T[tFX[Uw肷邩AL[Ŏw肷邩AI

    bool isChanged(void);
    bool isDecided(void);
    void setDecided(void);
    void releaseDecided(void);

    static void createButton(boost::shared_ptr<ButtonComponent>& button,
                             const TextProperty& normal,
                             const TextProperty& selected,
                             const TextProperty& pressed);
  };
};

#endif /* !BUTTON_COMPONENT_H */
