#ifndef TEXT_CONVERT_INTERFACE_H
#define TEXT_CONVERT_INTERFACE_H

/*!
  \file
  \brief eLXgϊ̃C^[tF[X

  \author Satofumi KAMIMURA

  $Id$
*/

#include <SDL.h>
#include <vector>


/*!
  \brief ͕ϊ̃C^[tF[X
*/
class TextConvertInterface {
public:
  virtual ~TextConvertInterface(void) {}

  /*!
    \brief ϊobt@̃NA
  */
  virtual void clear(void) = 0;

  /*!
    \brief ϊobt@ւ̓o^

    \param text [i] ϊ镶
  */
  virtual void setConvertBuffer(const std::vector<Uint16>& text) = 0;

  /*!
    \brief ϊobt@̎擾

    \param buffer [o] obt@̃f[^
  */
  virtual void getConvertBuffer(std::vector<Uint16>& buffer) = 0;

  /*!
    \brief ̒ǉ

    \param ch [i] ͕
  */
  virtual bool addChar(char ch) = 0;

  /*!
    \brief J[\
  */
  virtual bool moveLeft(void) = 0;

  /*!
    \brief J[\E
  */
  virtual bool moveRight(void) = 0;

  /*!
    \brief J[\
  */
  virtual bool moveUp(void) = 0;

  /*!
    \brief J[\
  */
  virtual bool moveDown(void) = 0;

  /*!
    \brief GXP[v
  */
  virtual bool escapePressed(void) = 0;

  /*!
    \brief BackSpace L[
  */
  virtual bool deleteBack(void) = 0;

  /*!
    \brief Delete L[
  */
  virtual bool deleteCurrent(void) = 0;

  /*!
    \brief ϊL[
  */
  virtual bool convertInput(void) = 0;

  // ϊ̕\邽߂̏擾
  // !!!
};

#endif /* !TEXT_CONVERT_INTERFACE_H */
