<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />

<!-- キーのチェック・復号化 -->
<og:bizLogic logics="an.OP0001S" keys="KEY" />
<og:value command="SET" key="CDANK" value="{@RETURN}" />

<og:equals val1="{@SYS.ANK_OUTPUT_TYPE}" nullCheck="true">
	<og:value command="SET" key="ANK_OUTPUT_TYPE" value="TABLE_EXCEL" />
</og:equals>
<og:equals val1="{@SYS.ANK_OUTPUT_TYPE}" nullCheck="true" notEquals="true">
	<og:value command="SET" key="ANK_OUTPUT_TYPE" value="{@SYS.ANK_OUTPUT_TYPE}" />
</og:equals>

<og:equals val1="{@ANK_OUTPUT_TYPE}" val2="_CALC" contains="true">
	<og:value command="SET" key="FILE_NAME" value="def.ods" />
	<og:value command="SET" key="WRITER_CLASS" value="Calc" />
</og:equals>

<og:equals val1="{@ANK_OUTPUT_TYPE}" val2="_CALC" contains="true" notEquals="true">
	<og:value command="SET" key="FILE_NAME" value="def.xls" />
	<og:value command="SET" key="WRITER_CLASS" value="Excel" />
</og:equals>

<og:file
	fileURL		= "{@USER.ID}"
	file1		= "{@FILE_NAME}"
	action		= "delete"
	useStop		= "false" />

<og:file
	fileURL		= "{@USER.ID}"
	file1		= "images.zip"
	action		= "delete"
	useStop		= "false" />

<og:query command="{@command}" displayMsg="" scope="request">
	select A.NAIYO QANAIYO,A.KBUNRUI
			,A.SITSUGRP QAGROUP,A.SITSUSGRP QASGROUP
			,case when A.IMGNAI is not null and A.IMGNAI != coalesce('',' ') then A.CDSITSU||'.'||A.IMGSNAI end QAIMAGE,A.IMGNAI QAIMAGE_ORIG
			,A.FGKEY,A.FGMUST,A.KLENGTH,A.KNOTE,A.SUONELINE,A.RSCODE RCODE,A.INIVAL,A.CSKEY,A.CSWAY,A.SUCS,A.VDCDTN,A.KAISETSU,A.SUPTRITSU,'' FGCORRECT, 0 KSCALE
			,A.SEQNO * 1000000 SEQNO
	from AN02 A
	where A.CDANK = '{@CDANK}'
	and A.FGJ = '1'
	union all
	select A.KNAME QANAIYO,'' KBUNRUI
			,'' QAGROUP, '' QASGROUP
			,case when A.IMGKVAL is not null and A.IMGKVAL != coalesce('',' ') then A.KVAL||'.'||A.IMGSKVAL end QAIMAGE,A.IMGKVAL QAIMAGE_ORIG
			,'' FGKEY,'' FGMUST,0 KLENGTH,'' KNOTE,0 SUONELINE,A.RKCODE RCODE,'' INIVAL,'' CSKEY,'' CSWAY,0 SUCS,'' VDCDTN,'' KAISETSU,0 SUPTRITSU,A.FGCORRECT,A.KSCALE
			,B.SEQNO * 1000000 + A.SEQNO SEQNO
	from AN03 A inner join AN02 B
	on A.CDANK = B.CDANK
	and A.CDSITSU = B.CDSITSU
	and B.FGJ = '1'
	where A.CDANK = '{@CDANK}'
	and A.FGJ = '1'
	order by SEQNO
</og:query>

<og:equals val1="{@LIST}" nullCheck="true" notEquals="true">
	<og:equals val1="{@ALL_OUT}" nullCheck="true" notEquals="true">
		<og:value command="SET" key="ADDTIONAL_COLS" value=",QASGROUP,QAIMAGE,FGKEY,FGMUST,KLENGTH,SUONELINE,RCODE,INIVAL,CSKEY,CSWAY,SUCS,VDCDTN,KAISETSU,SUPTRITSU,FGCORRECT,KSCALE" />
	</og:equals>

	<og:writeTable
		writerClass	= "{@WRITER_CLASS}"
		fileURL		= "{@USER.ID}"
		filename	= "{@FILE_NAME}"
		columns		= "QANAIYO,KBUNRUI,QAGROUP,KNOTE{@ADDTIONAL_COLS}"
		scope		= "request"
	/>

	<og:equals val1="{@DIRECT}" nullCheck="true">
		<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/{@FILE_NAME}" filename="{@FILE_NAME}" />
	</og:equals>
</og:equals>

<og:equals val1="{@IMAGE}" nullCheck="true" notEquals="true">
	<og:value command="SETTBL" action="ALL_APPEND" key="QAIMAGE_ORIG" tblScope="request" />
	<og:bizLogic logics="an.AN0008S" keys="CDANK,QAIMAGE_ORIG,USERID,FGTEMPLATE" />

	<og:equals val1="{@DIRECT}" nullCheck="true">
		<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/images.zip" filename="images.zip" />
	</og:equals>
</og:equals>

<og:equals val1="{@DIRECT}" nullCheck="true" notEquals="true">
	<og:forward page="upload.jsp" gamenId="AN0001" useRedirect="true" keys="DIRECT,CDANK_ORIG,fileList" vals="true,{@CDANK},{@FILE_NAME}" />
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
