/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_ENTRY;
import org.opengion.fukurou.security.HybsCryptography;

/**
 * アンケートコードの暗号化キーを復号化し、アンケートコードを戻り値として返します。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class OP0001S extends BizLogic_ENTRY {

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean check() {
		return must( "KEY" );
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean logic() {
		boolean isOk = false;

		try {
			set( "DECRYPTKEY", ( new HybsCryptography() ).decrypt( var( "KEY" ) ) );
			String sql = "select A.CDANK, A.CHECKKEY from AN01 A "
						+ "where A.CDANK = '{@DECRYPTKEY}' and A.FGJ in ('0','1')";
			sql( sql );

			if( var( "CDANK") != null && var( "CDANK" ).length() > 0 && var( "CDANK").equals( var( "CHECKKEY" ) ) ) {
				isOk = true;
			}
		}
		catch ( Throwable th ) {}

		if( isOk ) {
			rtn( var( "CDANK" ) );
		}
		else {
			error( 2, "ANE0005" );
		}

		return true;
	}
}

