/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.connection;

import iax.protocol.peer.Peer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class Connection
implements Runnable {
    private static final int BUFFER_LENGTH = 4096;
    private static final int IAX_PORT = 4569;
    private boolean running = true;
    private Peer peer;
    private InetAddress hostIAddr;
    private DatagramSocket socket;

    public Connection(Peer peer, String host) {
        this.peer = peer;
        try {
            this.hostIAddr = InetAddress.getByName(host);
            this.socket = new DatagramSocket();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() {
        Thread t = new Thread(this);
        t.start();
    }

    public synchronized void stop() {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            try {
                DatagramPacket packet = new DatagramPacket(new byte[4096], 4096);
                this.socket.receive(packet);
                this.recv(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void recv(DatagramPacket packet) {
        int length = packet.getLength();
        byte[] buffer = new byte[length];
        System.arraycopy(packet.getData(), 0, buffer, 0, length);
        this.peer.handleRecvFrame(buffer);
    }

    public void send(byte[] data) {
        try {
            DatagramPacket packet = new DatagramPacket(data, data.length, this.hostIAddr, 4569);
            this.socket.send(packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

