/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.frame;

import iax.protocol.frame.FrameException;
import iax.protocol.frame.FullFrame;

public class ControlFrame
extends FullFrame {
    public static final int HANGUP = 1;
    public static final int RINGING = 3;
    public static final int ANSWER = 4;
    public static final int BUSY = 5;
    public static final int PROCEEDING = 15;
    private byte[] data;

    protected ControlFrame() {
    }

    public ControlFrame(int srcCallNo, boolean retry, int destCallNo, long timeStamp, int oSeqno, int iSeqno, boolean subclassValueFormat, int subclass, byte[] data) {
        super(2, srcCallNo, retry, destCallNo, timeStamp, oSeqno, iSeqno, 4, subclassValueFormat, subclass);
        this.data = data;
    }

    public ControlFrame(byte[] buffer) throws FrameException {
        super(2, buffer);
        try {
            this.data = new byte[buffer.length - 12];
            System.arraycopy(buffer, 12, this.data, 0, this.data.length);
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] serialize() throws FrameException {
        try {
            byte[] superInBytes = super.serialize();
            byte[] result = new byte[superInBytes.length + this.data.length];
            System.arraycopy(superInBytes, 0, result, 0, superInBytes.length);
            System.arraycopy(this.data, 0, result, superInBytes.length, this.data.length);
            return result;
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }
}

