/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.frame;

import iax.protocol.frame.Frame;
import iax.protocol.frame.FrameException;
import iax.protocol.util.ByteBuffer;

public abstract class FullFrame
extends Frame {
    public static final int DTMF_FT = 1;
    public static final int VOICE_FT = 2;
    public static final int CONTROL_FT = 4;
    public static final int PROTOCOLCONTROL_FT = 6;
    public static final int DTMF_BEGIN_FT = 12;
    protected static final int FULLFRAME_HEADER_LENGTH = 12;
    private final int R_SHORTMASK = 32768;
    private final int DESTCALLNO_SHORTMASK = Short.MAX_VALUE;
    private final int C_BYTEMASK = 32768;
    private final int SUBCLASS_BYTEMASK = Short.MAX_VALUE;
    private int retryCount;
    protected boolean retry;
    protected int destCallNo;
    protected long timestamp;
    protected int oSeqNo;
    protected int iSeqNo;
    protected int frameType;
    protected boolean subclassPowerFormat;
    protected int subclass;

    protected FullFrame() {
    }

    protected FullFrame(int type, int srcCallNo, boolean retry, int destCallNo, long timeStamp, int oSeqno, int iSeqno, int frameType, boolean subclassPowerFormat, int subclass) {
        super(type, true, srcCallNo);
        this.retry = retry;
        this.destCallNo = destCallNo;
        this.timestamp = timeStamp;
        this.oSeqNo = oSeqno;
        this.iSeqNo = iSeqno;
        this.frameType = frameType;
        this.subclassPowerFormat = subclassPowerFormat;
        this.subclass = subclass;
        this.retryCount = 0;
    }

    protected FullFrame(int type, byte[] buffer) throws FrameException {
        super(type, buffer);
        try {
            byte[] aux = new byte[buffer.length - 2];
            System.arraycopy(buffer, 2, aux, 0, aux.length);
            ByteBuffer byteBuffer = new ByteBuffer(aux);
            int aux16bits = byteBuffer.get16bits();
            this.retry = (aux16bits & 0x8000) != 0;
            this.destCallNo = aux16bits & Short.MAX_VALUE;
            this.timestamp = byteBuffer.get32bits();
            this.oSeqNo = byteBuffer.get8bits();
            this.iSeqNo = byteBuffer.get8bits();
            this.frameType = byteBuffer.get8bits();
            int aux8bits = byteBuffer.get8bits();
            this.subclassPowerFormat = (aux8bits & 0x8000) != 0;
            this.subclass = this.subclassPowerFormat ? 1 << (aux8bits & Short.MAX_VALUE) : aux8bits & Short.MAX_VALUE;
            this.retryCount = 0;
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public boolean getRetry() {
        return this.retry;
    }

    public int getDestCallNo() {
        return this.destCallNo;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getOseqno() {
        return this.oSeqNo;
    }

    public int getIseqno() {
        return this.iSeqNo;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public boolean getSubclassPowerFormat() {
        return this.subclassPowerFormat;
    }

    public int getSubclass() {
        return this.subclass;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void incRetryCount() {
        ++this.retryCount;
    }

    public byte[] serialize() throws FrameException {
        try {
            byte[] superInBytes = super.serialize();
            byte[] thisInBytes = new byte[12];
            ByteBuffer byteBuffer = new ByteBuffer(10);
            int aux16bits = (this.retry ? 32768 : 0) + (this.destCallNo & Short.MAX_VALUE);
            byteBuffer.put16bits(aux16bits);
            byteBuffer.put32bits(this.timestamp);
            byteBuffer.put8bits(this.oSeqNo);
            byteBuffer.put8bits(this.iSeqNo);
            byteBuffer.put8bits(this.frameType);
            int aux8bits = (this.subclassPowerFormat ? 1 : 0) + (this.subclass & Short.MAX_VALUE);
            byteBuffer.put8bits(aux8bits);
            System.arraycopy(superInBytes, 0, thisInBytes, 0, superInBytes.length);
            System.arraycopy(byteBuffer.getBuffer(), 0, thisInBytes, superInBytes.length, byteBuffer.getBuffer().length);
            return thisInBytes;
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }
}

