/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.util;

import iax.protocol.frame.ControlFrame;
import iax.protocol.frame.DTMFFrame;
import iax.protocol.frame.Frame;
import iax.protocol.frame.FrameException;
import iax.protocol.frame.MiniFrame;
import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.frame.VoiceFrame;
import iax.protocol.util.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class FrameUtil {
    private static final int F_POS = 0;
    private static final int FRAMETYPE_POS = 10;
    private static final int MD5_SIZE = 16;
    private static final HashMap replyMap = new HashMap();

    static {
        int[] accept = new int[]{9, 1};
        int[] authreq = new int[]{1};
        int[] pong = new int[]{2};
        int[] regack = new int[]{13};
        int[] regauth = new int[]{17, 13};
        int[] regrej = new int[]{17, 13};
        int[] reject = new int[]{9};
        replyMap.put(7, accept);
        replyMap.put(8, authreq);
        replyMap.put(3, pong);
        replyMap.put(15, regack);
        replyMap.put(14, regauth);
        replyMap.put(16, regrej);
        replyMap.put(6, reject);
    }

    public static Frame deserialize(byte[] buffer) throws FrameException {
        int frameType;
        ByteBuffer byteBuffer = new ByteBuffer(buffer);
        try {
            boolean full;
            boolean bl = full = (byteBuffer.get16bits(0) & 0x8000) != 0;
            if (!full) {
                return new MiniFrame(buffer);
            }
            frameType = byteBuffer.get8bits(10);
            switch (frameType) {
                case 1: {
                    return new DTMFFrame(buffer);
                }
                case 4: {
                    return new ControlFrame(buffer);
                }
                case 6: {
                    return new ProtocolControlFrame(buffer);
                }
                case 2: {
                    return new VoiceFrame(buffer);
                }
                case 12: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
        throw new FrameException("Frame type unknown type:" + frameType);
    }

    public static byte[] md5(byte[] challenge, byte[] password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] input = new byte[challenge.length + password.length];
            System.arraycopy(challenge, 0, input, 0, challenge.length);
            System.arraycopy(password, 0, input, challenge.length, password.length);
            return digest.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int[] getReplySubclasses(int recvSubclass) {
        if (replyMap.containsKey(recvSubclass)) {
            return (int[])replyMap.get(recvSubclass);
        }
        return new int[0];
    }
}

