#ifndef __QUE_H__
#define __QUE_H__

#include "intmgr.h"
#include "list.h"

class Queue : public List
{
public:
    Queue(void) {}
    Object* peek(uint32 i) {return get(i);}
    virtual void enqueue(Object& obj) {
        add(obj);
    }
    Object* dequeue(void) {
        Object* obj = peek(0);
        if (obj != 0) remove(*obj);
        return obj;
    }
};

class Comparator
{
public:
    virtual int compare(Object& src1, Object& src2) = 0;
};

class PriorityQueue : public Queue
{
public:
    PriorityQueue(Comparator& c) : Cmp(c) {}
    void enqueue(Object& obj) {
        uint32 i = 0;
        Object* entry = peek(i);
        while (entry != 0) {
            if (Cmp.compare(obj, *entry) < 0) break;
            entry = peek(++i);
        }
        insert(i, obj);
    }

private:
    Comparator& Cmp;
};

#endif /* __QUE_H__ */
